/* pcxlib.h */
/* Copyright (c) 1992, 1993 Dave Boynton */

#if !defined(__LARGE__) && !defined(__HUGE__)
#error Wrong memory model
#endif

#ifndef PCX_H                      /* don't do more than once */
#define PCX_H

#define PCXLIB_VERSION         "1.8"

#define ALIGN_DWORD(x) (((x)+3)/4 * 4)
#define What_WPlanes    (SQread_reg(2))

/* following constants are used internally */
#define PCXUNK             -1        /* unknown/invalid */
#define PCXMONO             0
#define PCX4colors          1
#define PCX8colors          4
#define PCX16colors         2
#define PCX256colors        3
#define PCX32kcolors        5           /* no known pcx file */
#define PCX64kcolors        6           /* no known pcx file */
#define PCX16mcolors        7           /* similar to 16 color (rgb planes) */


#define PCXDBGin           (pcxdbglevel+=4)
#define PCXDBGout          (pcxdbglevel-=4)

struct PCXRGB {
       unsigned char r, g, b;
};

#define MAGICID         0x0a
#define PCXVERSION      0x05    /* for 256 files, 0x03 for 16 color */

typedef struct {
	char               MagicId;       /* must be 0x0a */
	char               Version;       /* 0x03 16 color, 0x05 256 color */
	char               Encoding;      /* req'd 1=run length encoded */
	char               BitsPixel;     /* 1=mono or 16color,8=256 or 24bit */
	int                Xmin, Ymin;    /* normally zero */
	int                Xmax, Ymax;
	int                Hres, Vres;    /* used inconsistently, not req. for writing */
	struct PCXRGB      Palette[16];   /* used only on 16 color pcx's */
	char               Reserved;
	char               Planes;        /* 1=mono or 256,3=24bit,4=16color */
	unsigned int       bytesline;     /* not needed on write, calc'd */
	int                PaletteInfo;   /* often misused, don't need on write */
	char               Filler[58];  /* there's other stuff here, but */     
					/* it's rarely used */
} PCXH;

#define  MAXAREA          65520L       /* 64k - 16 bytes (for malloc) */

typedef struct {
       char              *name;
       FILE              *fp;
       PCXH              *h;
       unsigned char     *palette; /* for 256 color pcx's w/palette */
       long              *marks;   /* set to NULL when marks not set */
       unsigned char     *buffer;  /* pointer to scan line buffer */
       int               next_scan,buffer_scan;

       int               type;    /* PCXUNK= -1 =unknown/invalid
				     PCXMONO= 0 =mono
				     PCX4colors     1 =4  color
				     PCX16colors=   2 =16 color seg/line
				     PCX256colors=  3 =256 color  */
       unsigned          w, l;
       char              cw, cl;
       long              image_size;
       int               read_or_write;  /* 0 = readonly, 1 = writeonly */
       unsigned          num_marks; /* set to 0 initially */
} PCXF;

#ifdef _cplusplus
extern "C" {
#endif

PCXF  *        fopenPCXr(char *name); /* reads & validates header, reads 
					the palette (if present), and positions
					the file pointer to the first byte of
					scan line 0 (using fseekPCX(,0)). */
PCXF  *        fopenPCXw(char *name, PCXH *h, char *palette);
				      /* opens a new file for write, writes
					the header, leaves you ready to
					write scan line 0. */
int            fseekPCX(PCXF *pcxfile, unsigned y); /* seek scan line y */
int            fclosePCX(PCXF *pcxfile);
					/* if closing a write file, you must
					call _write_pcx_palette() first! */
					
int            PCXrealizepalette(PCXF * pcxfile, int depth/*6 or 8*/);
					/* write pcxfile's palette to the
					VGA registers */

int            flashPCX(char *filename, 
			int highest,    /* 1=set highest allowable mode,0=not */
			int depth,      /* bits per color in palette, 6 or 8 */
			int returnmode /*0=immediately,1=waitforkey*/);
			/* given a file, read the header and set a new
			video mode (VGA or VESA, 256color or 16color) and
			display the file, allowing panning with the arrows
			pgup, pgdn, home, & end keys. returns the key that
			was pressed (other than arrows, pgup, etc.). */

/* 
the following functions have very similar parameters: 
	*d,          destination in memory,
	dw, dl,      destination logical width, e.g. 320x200 for a 
			mode 0x13 screen,
	dx, dy,      destination upper right pixel address, therefore,
			the first destination pixel address is probably
			(void *)(d+dw*dy+dx). I say probably because VESA
			modes are paged, therefore work very differently.
			The fdisp functions hide the details of VESA modes
			for you.
	x0, y0,      source upper right pixel address,
	x1, y1,      source lower left pixel address,
	PCXF *p,     source pcx file structure 
*/

int   fread8PCX(char *d, unsigned dw, unsigned dl,
		unsigned dx, unsigned dy,
		unsigned x0, unsigned y0, 
		unsigned x1, unsigned y1, 
		PCXF *p);

/* fdisp8PCX may be used in VESA modes with no additional work          */
/* (other than  setting the mode) !!                                    */
int   fdisp8PCX(unsigned dx, unsigned dy,
		unsigned x0, unsigned y0, 
		unsigned x1, unsigned y1, 
		PCXF *p);

/* fread4PCX reads and converts pixels into a 1 pixel/1 byte format, suitable
   for conversion to a different format */
int   fread4PCX(char *d, unsigned dw, unsigned dl,
		unsigned dx, unsigned dy,
		unsigned x0, unsigned y0, 
		unsigned x1, unsigned y1, 
		PCXF *p);

/* fdisp4PCX reads and displays in a 16 color VGA (planar) format. Bad 
things will happen if the video adapter isn't already in a 16 color mode !!! */
int   fdisp4PCX(unsigned dx, unsigned dy,
		unsigned x0, unsigned y0, 
		unsigned x1, unsigned y1, 
		PCXF *p);

/* This function for monochrome .pcx files is untested!  I don't have     */
/* any mono pcx files to test it with. I'm not interested in mono files, */
/* but if someone has some I could test with, send via Compuserve or  */
/* internet. */
int   fread1PCX(char *d, unsigned dw, unsigned dl, 
		unsigned dx, unsigned dy,
		unsigned x0, unsigned y0, 
		unsigned x1, unsigned y1, 
		PCXF *p);


/* low-level read/write,
	use these to do line-by-line conversions to other formats
*/

/* 
linebuffer must be large enough to hold x1-x0+1 bytes, these functions are
called four times for 16-color files, each byte holding 8 pixels, or
three times for 24-bit color files, each byte is part of a 24-bit pixel.
*/
unsigned       _read_pcx_line(PCXF *pointer, char * linebuffer,
			      unsigned x0, unsigned x1);
unsigned       _write_pcx_line(PCXF *pointer, char * linebuffer,
			       unsigned x0, unsigned x1,
			       unsigned char fill);

/* when writing a 256 color file, call _write_pcx_palette() just before 
closing.
*/
void           _write_pcx_palette(PCXF *pointer);

void           _read_palette(PCXF *p); /* called by fopenPCXr() */


void           Start_pcxdebug(char *path);
void           Close_pcxdebug(void);

#ifdef _cplusplus
}
#endif

#ifdef   PCX_LIB
		int  PCXerror=0;
		FILE *pcxdebug;
		int  pcxdebugtimeson=0;
		int  pcxdbglevel=0;
#else
	 extern int  PCXerror;
	 extern FILE *pcxdebug;
	 extern int  pcxdebugtimeson;
	 extern int  pcxdbglevel;
#endif

#endif   /* PCX_lib */



