/* vidlib.h */
/* Copyright (c) 1992, 1993 Dave Boynton */

#if !defined(__LARGE__) && !defined(__HUGE__)
#error Wrong compiler model: must be large or huge
#endif

#if defined(DOSX286)
#error The vidlib/vesa libraries not ported to protected mode
#endif

#ifndef __VIDLIB__
#define __VIDLIB__

#ifndef __STDIO_H
#include <stdio.h>
#endif

#define  VIDLIB_VERSION    "1.8"

#define BIOScrtmode        (*((char *)    0x00000449L))
#define BIOScrtcols        (*((char *)    0x0000044aL))
#define BIOScrtrows        (*((char *)    0x00000484L))
#define BIOScrtpoints      (*((char *)    0x00000485L))
#define BIOScrtbuflen      (*((unsigned *)0x0000044cL))
#define BIOScrtstartoff    (*((unsigned *)0x0000044eL))
#define BIOScursor_page1   (*((unsigned *)0x00000450L))
#define BIOScursor_page1x  (*((unsigned char *)0x00000450L))
#define BIOScursor_page1y  (*((unsigned char *)0x00000451L))
#define BIOScrtpage        (*((char *)    0x00000462L))

#define DACSIZE            768
#define DEFAULTDAC         ((char *) -1L)

#define WPlane0            0x01
#define WPlane1            0x02
#define WPlane2            0x04
#define WPlane3            0x08
#define WPlaneALL          0x0f

#define VM_320x200x256     0x13
#define VM_640x480x16      0x12

/******************************* Global Data **************************/
#ifdef VIDLIB               /* when compiling the vidlib.c only */
	       char _vidinit=0;
	       char _olddacs[DACSIZE];
      unsigned char _oldmode;
      unsigned int  _screen_width;
      unsigned int  _screen_length;
      unsigned int  _memory_length;
	  char *_screen_start;
	  char *_screen_end;
      unsigned short _background_color=0;
      unsigned short _foreground_color=0x40;
	       char  tdbg[120];
	       FILE *vgadebug=NULL;
#else
extern          FILE *vgadebug;
extern          char _vidinit;
extern          char _olddacs[DACSIZE];
extern unsigned char _oldmode;
extern unsigned int  _screen_width;      /* in bytes */
extern unsigned int  _screen_length;
extern unsigned int  _memory_length;     /* in total scan lines, e.g.
					    modes 0x0e,0x10, and 0x12= 819,
					    even though a different number
					    are displayed in each */

extern    char   *_screen_start;      /* Usually 0xA0000000 */
extern    char   *_screen_end;        /* actually, the first byte after
					    the displayed portion */
extern      unsigned short _background_color;
extern      unsigned short _foreground_color;
extern         char  tdbg[135];

#endif /* endif VIDLIB */


#ifdef __cplusplus
extern "C" {            /* allow compiling in TurboC++ mode */
#endif

int    Vinit(void);
void   Vclose(void);
void   Vrestorestate(void *savebuffer);
void * Vsavestate(void *savebuffer);
int    isVGA(void);             /* returns 0 if no, 1 if yes */
void   Start_vgadebug(char *path);
void   Close_vgadebug(void);

int   VGAmode(unsigned int mode, char *palette);   /* palette may be NULL */

int   Textmode(int lines);     /* 25, 28, 33, 40, 50 are valid */
int   _select_scanline_count(int scans);
int   _select_character_points(int points);

/* the following routines make use of _screen_width, _screen_length, and
  _screen_start to check for logical errors, so any changing of VGA registers
   that change these attributes should be reflected in these variables */

    /* area fills */
int Vfill256(unsigned dx, unsigned dy, unsigned sdx, unsigned sdy,
		unsigned color);

    /* video to video copy */
int Vcopy256(unsigned dx, unsigned dy,
	     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vcopy16(unsigned dx, unsigned dy,
	    unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

    /* System memory to video copy */
int Vdisp256(unsigned dx, unsigned dy,
	     char *s, unsigned sw, unsigned sl,
	     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vdisp16(unsigned dx, unsigned dy,
	    char *s, unsigned sw, unsigned sl,
		     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

    /* Video to System memory copy */
int Vcapt256(char *d, unsigned dw, unsigned dl,
		      unsigned dx, unsigned dy,
		      unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vcapt16(char  *d, unsigned dw, unsigned dl,
		     unsigned dx, unsigned dy,
		     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);


/* low level routines */
void Select_RPlane(int plane);
void Select_Wmode(int mode);    /* mode ranges 0-3 for VGA */
int  What_Wmode(void);
void Select_WPlane(int planes);    /* planes = bit mask
						0=plane 0 write enable,
						1=plane 1, etc.  */
int            SQread_reg(int reg);
void           SQset_reg(int reg, int value);
void           SQset_regm(int reg, int value, int bitmask);
void           Vdisable_refresh(void);
void           Venable_refresh(void);   /* doesn't work in text mode ? */
int            GCread_reg(int reg);
void           GCset_reg(int reg, int value);
void           GCset_regm(int reg, int value, int bitmask);
int            ACread_reg(int reg);
void           ACset_reg(int reg, int value);
void           ACset_regm(int reg, int value, int bitmask);
#define        Vborder_color(x)    (ACset_reg(0x11, (x)))
int            MOread_reg(void);
void           MOset_reg(int value);
void           MOset_regm(int value, int mask);
int            CRTCread_reg(int reg);
void           CRTCset_reg(int reg, int value);
void           CRTCset_regm(int reg, int value, int bitmask);
void           Vwait_vretrace(void);
void           Vwait_hretrace(void);
void           L40set(void); /* line drawing characters don't connect in this
				mode */
void           L33set(void);
extern unsigned char EGA12set[256][12]; /* smaller (8x12) ega-like font */
					/* used in the 33 line text mode */

void  ReadDACs(void *palette);
void  ReadDACsn(void *palette, int first, int number);
void  WriteDACs(void *palette);
void  WriteDACsn(void *palette, int first, int number);
int   LoadDACs(int filehandle, char *savearea);  /* savearea must be */
int   SaveDACs(int filehandle, char *savearea);  /* DACSIZE bytes */
/* for the EGA compatible palette register (0-15) */
void  Load_Palette(int start, int count, char *palette);
int   putstty(const char *s, int color); /* uses BIOS routine */
int   Vputs(const char *s); /* calls putstty(s, _foreground_color); */
void  Vgotoxy(int col, int row);         /* uses BIOS routine */

/* miscellaneous utilities */
void * normalize(void *); /* convert a far pointer to a huge. */
char * memcpyb(char *dest, char *src, unsigned count);
	   /* garauntees one byte at a time, unlike memcpy, which will
	      attempt to copy by words if on a 286,386,486,etc. */
char * memcpybr(char *dest_end, char *src_end, unsigned count);
	   /* same as memcpyb, except a reverse direction move (bottom to top).
	      Note that the pointers must be to the last byte in the area. */

#ifdef _cplusplus
}
#endif

/* The following macros are normally in <dos.h> on TurboC and TurboC++   */
/* but get excluded if you compile with ANSI-keywords only. I'm changing */
/* their definition here to better compile under ANSI compilers. */

#ifdef __STDC__
#define MK_FP(seg,off)\
(normalize((void *)((unsigned long)seg << 16) + (unsigned long)off))

#define FP_OFF(fp)\
((unsigned)((unsigned long)normalize(fp) & (unsigned long)0x0000ffffL))

#define FP_SEG(fp)\
((unsigned)((unsigned long)normalize(fp)>>16))

#endif


/* endif #define __VIDLIB__ */
#endif
