/* vesa.h */
/* Copyright (c) 1992, 1993 Dave Boynton */

#ifndef __VESALIB__
#define __VESALIB__

#ifndef __VIDLIB__
      unsigned int  _screen_width;
      unsigned int  _screen_length;
	  char *_screen_start;
#endif

/* VESA mode values */
#define VM_640x400x256    0x0100
#define VM_640x480x256    0x0101
#define VM_800x600x16     0x0102
#define VM_800x600x256    0x0103
#define VM_1024x768x16    0x0104
#define VM_1024x768x256   0x0105
#define VM_1280x1024x16   0x0106
#define VM_1280x1024x256  0x0107
#define VM_80x60          0x0108        
#define VM_132x25         0x0109
#define VM_132x43         0x010a
#define VM_132x50         0x010b
#define VM_132x60         0x010c
#define VM_320x200x32K    0x010d
#define VM_320x200x64K    0x010e
#define VM_320x200x16M    0x010f
#define VM_640x480x32K    0x0110
#define VM_640x480x64K    0x0111
#define VM_640x480x16M    0x0112
#define VM_800x600x32K    0x0113
#define VM_800x600x64K    0x0114
#define VM_800x600x16M    0x0115

#define MAX_ROWS          1024
		/* modes with more that 1024 rows aren't supported */
#define MAX_MEMORYBLK     32
		/* in 64k blocks, or 2meg */
#define MAX_PAGES         256
		/* 4k pages * 256 = 1meg, or 2meg cards w/4k pages are bad */


/* Vminfo.modeattr values */
#define VA_DISPLAY_OK     0x0001
#define VA_OPTIONAL_OK    0x0002
#define VA_BIOSTEXT_OK    0x0004
#define VA_COLOR_OK       0x0008
#define VA_GRAPH_OK       0x0010

/* Vminfo.Window?attr values */
#define VW_SUPPORTED     0x01
#define VW_READABLE      0x02
#define VW_WRITABLE      0x04

/* state buffer values */
#define VS_HARDWARE     0x0001
#define VS_BIOS         0x0002
#define VS_DAC          0x0004
#define VS_SVGA         0x0008

struct  vesainfo {
	char            signature[4];   /* shoud be "VESA" */
	unsigned char   minor_version;
	unsigned char   major_version;
	char *          OEMinfo; /* 4 byte */
	char            capabilities[4];
	int *           modeptr; /* 4 byte */
	unsigned int    TotalMemory; /* number of 64k blocks, v1.1+ */
	char            Reserved[236]; /* info calls always need 256 bytes */
};

typedef enum { text, cga, herc, four_plane, packed_pixel, nonchain_256,
		direct, YUV, reserved } mode_type;

struct  vesamodeinfo {
	int     modeattr;
	char    WindowAattr;
	char    WindowBattr;
	int     granularity;
	int     size;
	unsigned int     Asegment;
	unsigned int     Bsegment;
	void    (*SetWindowFunction)(void);
	unsigned int bytesperline;

	/* optional information (when bit 1 of modeattr is set) */
	/* mandatory under VBE 1.2 */

	int     XPixels;
	int     YPixels;
	char    charwidth;
	char    charlength;
	char    planes;
	char    bits;
	char    banks;                  /* CGA/Herc */
	char    memorymodel;    /* use mode_type */
	char    banksize;               /* in k bytes */
	char    NumberOfImagePages;     /* v1.1 only */
	char    ReservedB;

	/* following valid under 1.2 for direct color and YUV modes */
	char RedMaskSize;
	char RedFieldPosition;
	char GreenMaskSize;
	char GreenFieldPosition;
	char BlueMaskSize;
	char BlueFieldPosition;
	char RsvdMaskSize;
	char RsvdFieldPosition;
	char DirectColorModeInfo;

	char    Reserved[216];
};

struct tagBreakEntry {
	int    Row, Col;
};

struct tagRowEntry {
	   int    Page;           /* page of row at column 0 */
  unsigned int    Offset;         /* offset into screen at start of row */
	   int    BreakColumn;    /* column of break, or -1 if no break */
	   int    reserved;
};

#ifdef VESA
struct          vesainfo   Vinfo;
struct      vesamodeinfo   Vminfo;
		     int   vesareadpage, vesawritepage;
		     int   vesapager=-1;
		     int   vesapagew=-1;
	    unsigned int   Vnext_break_rowr;
	    unsigned int   Vnext_break_colr;
	    unsigned int   Vnext_break_roww;
	    unsigned int   Vnext_break_colw;
	    unsigned long  _window_size;
		     int   _bytesperpixel;
    struct tagBreakEntry * _BreakTable=NULL;
      struct tagRowEntry * _RowTable=NULL;
    void (*VESAsetpageptr)(char window, unsigned page);
#else
extern   struct vesainfo   Vinfo;
extern struct vesamodeinfo Vminfo;
extern               int   vesareadpage, vesawritepage;
extern        unsigned int vesapager, vesapagew;
extern        unsigned int Vnext_break_rowr;
extern        unsigned int Vnext_break_colr;
extern        unsigned int Vnext_break_roww;
extern        unsigned int Vnext_break_colw;
extern       unsigned long _window_size;
extern              int    _bytesperpixel;
extern struct tagBreakEntry * _BreakTable;
extern struct tagRowEntry * _RowTable;
extern void (*VESAsetpageptr)(char window, unsigned page);
#endif

/* If compiling under TurboC++, make sure it knows how to link. */
#ifdef _cplusplus
extern "C" {
#endif

void             VESAinit(void);  /* calls Vinit() */
void             VESAclose(void); /* calls Vclose() */
int              VESAmode(unsigned int mode, char *palette);
int              isVESA(void);           /* 1=VESA ok., 0=no VESA */
		 /* see if a VESA mode is valid */
int              isVESAmode(int mode);   /* find an acceptable mode 
					    returns -1 on not valid,
					    mode_type if o.k. */

struct vesainfo         *getVESAinfo(void);
struct vesamodeinfo     *getVESAmodeinfo(unsigned int mode,
			struct vesamodeinfo *modebuffer);

/* new functions in VBE v1.1 */
unsigned int     VESAGetLogicalLineLen(void);
unsigned int     VESASetLogicalLineLen(unsigned int length);
unsigned int     VESASetDisplayStart(unsigned int column, unsigned int row);
unsigned int     VESAGetDisplayStart(void);

/* new functions in VBE v1.2 */
int              VESAGetDACPaletteControl(void);
int              VESASetDACPaletteControl(int bits);

/* local stuff */
long             Vabsolute_offset(int r,int c);
int              VESAwhat_page(int r,int c);  
unsigned int     VESAwhat_offset(int r,int c);


void             VESAsetpager(unsigned page);
void             VESAsetpagew(unsigned page);

int              VESAfill256(unsigned dx, unsigned dy,
			     unsigned sdx, unsigned sdy,
			     unsigned color);
int              VESAcopy256(unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy);
int              VESAdisp256(unsigned dx, unsigned dy,
			     char *s, unsigned sw, unsigned sl,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction);
int              VESAcapt256(char *d, unsigned dw, unsigned dl,
			     unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction);
void VESAhline(int x1, int x2, int y, unsigned int color);
void VESAvline(int x, int y1, int y2, unsigned int color);

/* low level routine to copy part of one line, checking for destination
   breaks (doesn't check for source breaks) */
int _VESAcopylinePP(int dx, int dy, char *src, int sdx, int bytesperpixel);
int _VESAcopyline8PP(int dx, int dy, char *src, int sdx);

void VESAhlinePP(int x1, int x2, int y, unsigned long color, int bytesperpixel);
void VESAvlinePP(int x, int y1, int y2, unsigned long color, int bytesperpixel);

int              VESAfillPP(unsigned dx, unsigned dy,
			     unsigned sdx, unsigned sdy,
			     unsigned color, int bytesperpixel);
int              VESAcopyPP(unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int bytesperpixel);
int              VESAdispPP(unsigned dx, unsigned dy,
			     char *s, unsigned sw, unsigned sl,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction,
			     int bytesperpixel);
int              VESAcaptPP(char *d, unsigned dw, unsigned dl,
			     unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction,
			     int bytesperpixel);
void             VESAWriteDot8PP(unsigned dx, unsigned dy, 
			     unsigned char color);
void             VESAWriteDot16PP(unsigned dx, unsigned dy, 
			     unsigned int color);
void             VESAWriteDot24PP(unsigned dx, unsigned dy, 
			     unsigned long color); /* True Color! */

int              VESAcopy16(unsigned dx, unsigned dy,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);

int              VESAdisp16(unsigned dx, unsigned dy,
			    char *s, unsigned sw, unsigned sl,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);
int              VESAcapt16(char *d, unsigned dw, unsigned dl,
			    unsigned dx, unsigned dy,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);

#ifdef _cplusplus
}
#endif



#endif
