program ShowPCX;

(* Sample implementation of PCX.TPU. Enter a filename (extension optional)
  on the command line or, if running under the IDE, in the Parameters box.
  You can optionally override the default video mode with a second argument,
  entered as a decimal or Pascal hex number. *)

{$X+}

uses DOS, CRT, PCX;

CONST
         PCXMode: word = AutoSet;

VAR
         PCXFileName: pathstr;
         Dir: DirStr;
         Name: NameStr;
         Ext: ExtStr;
         StartMode: word;
         Msg: string;
         Temp, ValErr, ErrNo: integer;
         VESARec: VESAInfoRec;

procedure WriteError(ErrMsg: string);

VAR  Msg: string;

begin
writeln;
writeln(ErrMsg);
writeln;
writeln('Press any key.');
ReadKey;
end;

BEGIN
StartMode:= GetMode;
PCXFileName:= paramstr(1);
if PCXFileName = '' then
begin
  writeln('Usage:');
  writeln('showp filename[.pcx] [mode]');
  writeln;
  halt;
end;
FSplit(PCXFileName, Dir, Name, Ext);
if Ext = '' then PCXFileName:= PCXFileName + '.PCX';
if paramcount > 1 then
begin
  val(paramstr(2), Temp, ValErr);
  if ValErr = 0 then PCXMode:= Temp;
end;
if (not WeSupport(PCXMode)) and (PCXMode <> AutoSet) then
begin
  WriteError('The requested video mode is not supported by this program.');
  halt;
end;
if (PCXMode >= $100) then
begin
  if not DetectVESA(VESARec) then
  begin
    writeln;
    write('VESA BIOS extensions not found. Your video card may require');
    write('a program (typically called VESA.COM) to be loaded so that');
    write('Super-VGA images can be displayed without a special driver.');
    writeln;
    halt;
  end;
  if not HardwareSupports(PCXMode) then
  begin
    WriteError('Your card or VESA BIOS does not support the requested video mode.');
    halt;
  end;
end;
ErrNo:= (ReadIt(PCXFileName, PCXMode, Blackout or HCenter or VCenter));
if ErrNo <> 0 then
begin
  SetMode(3, NoOptions);
  ReportError(ErrNo, Msg);
  WriteError(Msg);
  halt;
end
else ReadKey;
SetMode(StartMode, NoOptions);         { Restore text mode }
END.
