#include <stdio.h>

typedef char pathstr[80];

struct rgb_struct {
  unsigned char r, g, b;
};

// Structures

struct pcx_header_struct {
  unsigned char signature, version, code, bits_per_plane;
  int xmin, ymin, xmax, ymax;        // image dimensions
  int hres, vres;                    // resolution of originating device
  rgb_struct palette[16];
  unsigned char reserved, num_planes;
  int bytes_per_line;
  unsigned char other_stuff[60];
};
struct VESA_info_struct {
  unsigned char signature[4];
  int  version;
  int far *oem_ptr;
  unsigned char capabilities[4];
  unsigned int far *mode_list_ptr;
  unsigned char reserved[256];
  /* Structure is padded because some VESA BIOSes are
     said to return too many bytes from function 0. */
};

struct mode_info_struct {
  int  attributes;
  unsigned char windowA_atts, windowB_atts;
  unsigned int granule_kb, window_size;
  unsigned int windowA_start, windowB_start;
  int  far *function_ptr;
  unsigned int bytes_per_line;
  unsigned int xres, yres;
  unsigned char other_stuff[234];
};

// Functions

int read_it(pathstr pic_file_name, int mode, int options);
FILE *open_file(pathstr pic_file_name, char *file_mode,
		pcx_header_struct *header);
int get_mode(void);
void set_mode(int mode, int options);
char *report_error(int error);
int we_support(unsigned int mode);
int hardware_supports(unsigned int mode);
int detect_VESA(VESA_info_struct *VESA_rec);

// Constants for constructing options word:

#define no_options 0
#define save_mem   1        // preserve video memory not overwritten
#define hcenter    2        // center the image horizontally
#define vcenter    4        // center the image vertically
#define blackout   8        // blank screen till whole image written

#define auto_set   0        // can be passed to read_it

