/* Sample implementation of PCX.CPP. Enter a filename (extension optional)
  on the command line or, if running under the IDE, in the Parameters box.
  You can optionally override the default video mode with a second argument,
  entered as a decimal. */

#include "pcx.h"
#include <dir.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

void main(int argc, char *argv[])
{
  int pcx_mode = auto_set;
  int start_mode = get_mode();
  int err = 0;
  int n;
  char file_name[80];
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  int flags;
  VESA_info_struct VESA_inf;

  if (argc > 1) {
    strcpy(file_name, argv[1]);
    flags = fnsplit(file_name, drive, dir, file, ext);
    if (!(flags & EXTENSION)) {
      strcpy(ext, ".PCX");
      fnmerge(file_name, drive, dir, file, ext);
    }
    if (argc > 2) {
      n = atoi(argv[2]);
      if (n) pcx_mode = n;
    }
    if ((!we_support(pcx_mode)) && (pcx_mode != auto_set)) {
      printf("The requested video mode is not supported by this program.\n");
      getch();
      return;
    }
    if (pcx_mode >= 0x100) {
      if (!detect_VESA(&VESA_inf)) {
	printf("VESA BIOS extensions not found. Your video card may require\n"
	   "a program (typically called VESA.COM) to be loaded so that\n"
	   "Super-VGA images can be displayed without a special driver.\n\n");
	getch();
	return;
      }
      if (!hardware_supports(pcx_mode)) {
	printf("Your card or VESA BIOS does not support the requested "
	       "video mode.\n");
	getch();
	return;
      }
    }
    err = read_it(file_name, pcx_mode, blackout | hcenter | vcenter);
    if(err) printf(report_error(err));
  }
  else printf("Usage:\nshow filename[.pcx] [mode]\n\n");
  getch();
  set_mode(start_mode, no_options);
  return;
}
