/* +----------------------------------------------------------------------+
   |                                                                      |
   |                       p c   V M M Version 1.0                        |
   |                                                                      |
   |                      Created by SUPERIOR SOFT                        |
   |                                                                      |
   |    Copyright (C) 1988,1989,1990 by Superior Soft                     |
   |                                                                      |
   |    All rights reserved. No part of this program source code may      |
   |    be reproduced, stored in a retrieval system, or transmitted,      |
   |    in any form or by any means, electronic, mechanical,              |
   |    photocopying, recording, or otherwise.                            |
   |                                                                      |
   | PCVMM.H                                                              |
   +----------------------------------------------------------------------+
*/

#define PS_FREE         ((UCHAR)0U)         // page not in use
#define PS_IN_MEM       ((UCHAR)1U)         // in conventional memory
#define PS_DISK         ((UCHAR)2U)         // on disk
#define PS_EMS          ((UCHAR)3U)         // in Expanded memory
#define PS_XMS          ((UCHAR)4U)         // in Extended memory
#define PAGE_SIZE       16384U              // 16K page (plus one paragraph)
#define PAGE_BLOCKS     2000U               // 32M worth of 16k pages
#define VMM_EXT         "VMM"               // swap file extension
#define NULLVMM         ((VHAND)0L)         // used to return error in page functions
#define VH_NULL         ((VHAND)0L)         // used to return error in page functions
#define MEMFREE         ((USHORT)0x0001)    // Bit 0 is used to indicate FREE block
#define _ONE            ((USHORT)0x0001)    // Another Bit 0 mask
#define MEMEND          ((USHORT)0xFFFE)    // Block size value to indicate mem chain end
#define MEMHDRSIZE      ((USHORT)sizeof(USHORT))    // Number of bytes used by mem chunk hdr
#define GETPAGEID(x)    ((x)->pageid)
#define GETPAGEOFF(x)   (((long)((x)->pageid))*PAGE_SIZE)
#define MAXDIRPATH      64
#define SET_MEMPOOL(x)  (memorypool=(UCHAR)(x)) // set the current memory pool

#if defined(DEBUG)
#define ERROR(x)        cprintf( "\r\nERROR: " __FILE__ ": %d: " x, __LINE__ ),getch()
#else
#define ERROR(x)
#endif

#if !defined(TRUE)
#define TRUE        1
#define FALSE       0
#endif

// errors
#define VMM_ERR_NO_PAGE_MEM     1
#define VMM_ERR_NO_SWAP_FILE    2

// misc.
typedef unsigned short  USHORT;
typedef unsigned char   UCHAR;

// virtual memory handle
typedef unsigned long   VHAND;

// virtual memory address component structure
typedef struct VMMID
{
    USHORT          pageoff;
    USHORT          pageid;

} VMMID;

// virtual memory address structure
typedef union VMADDR
{
    VMMID           vmm;
    VHAND           vh;

} VMADDR;


typedef struct EMM
{
    USHORT          emm_handle,
                    emm_page;

} EMM;

typedef struct XMS
{
    USHORT          emb_handle;

} XMS;

typedef struct SEG_OFF
{
    USHORT          off;
    USHORT          seg;

} SEG_OFF;

typedef union MEMINFO
{
    SEG_OFF     so;
    long        file_offset;
    USHORT  far *wptr;
    UCHAR   far *bptr;
    void    far *mem_addr;
    VMADDR      va;
    XMS         xms;

} MEMINFO;

typedef struct PAGE
{
    struct PAGE     far *lru_prev;
    struct PAGE     far *lru_next;


    USHORT          largestchunk;  // largest free chunk in memory page

    MEMINFO         meminfo;

    USHORT          pageid;
    UCHAR           status;
    UCHAR           mempool;

} PAGE;

typedef struct LRU_ROOT
{
    struct PAGE far *head,
                far *tail;

} LRU_ROOT;

/* external refernced data */
extern UCHAR memorypool;


/* Function prototypes */
extern  unsigned int pascal open_vmm(char *spath);
extern  void pascal close_vmm(void);
extern  PAGE far * pascal alloc_page(void );
extern  void pascal make_page_head(LRU_ROOT *lru, PAGE far *pg);
extern  void pascal add_lru_head( LRU_ROOT *, PAGE far *);
extern  void pascal add_lru_tail( LRU_ROOT *, PAGE far *);
extern  PAGE far * pascal rem_lru_tail( LRU_ROOT *);
extern  VHAND pascal vmm_alloc(USHORT size);
extern  VHAND pascal vmm_realloc( VHAND vh, USHORT size );
extern  USHORT pascal expand_mem_chunk( PAGE far *pg, USHORT pgoff, USHORT size );
extern  void pascal vmm_free( VHAND vh );
extern  void pascal free_mem_chunk( PAGE far *pg, USHORT pgoff );
extern  void pascal init_mem_page( PAGE far *pg);
extern  void far * pascal vmm_deref( VHAND vmmaddr );
extern  USHORT pascal vmm_size(VHAND vh);
extern  void pascal vmm_dump(void);
extern  USHORT pascal vmm_check(VHAND vh);
extern  void pascal vmm_pack(void);
extern  USHORT pascal alloc_mem_chunk( PAGE far *pg, register USHORT thesize );
extern  void pascal free_page(struct PAGE far *pg);
extern  USHORT pascal read_page(struct PAGE far *pg);
extern  USHORT pascal raw_read_page(struct PAGE far *pg);
extern  USHORT pascal write_page(struct PAGE far *pg);
extern  void far * pascal dmalloc(USHORT size);
extern  void far * pascal drealloc(void far *memptr,USHORT size);
extern  int pascal _dos_seek(int handle,long offset,int origin,long *seekpos);
extern  char * pascal build_swap_path(char *spath);
extern  void pascal dfree(void far *memptr);
extern  void pascal debugmem(void);
extern  void pascal debugstub(void);



/*EOF*/



