
/* requires atleast MSC 5.0 */

#include <stdio.h>
#include <conio.h>

#include "pcvmm.h"

#define MAXALLOCS   10000


typedef struct num_list
{
    VHAND next;
    char  number[20];
    char  dummy_data[128];
} NUM_LIST;


void        main(void);

static void NearToFarCopy( void far *dst, void *src, unsigned short len );
static void FarToNearCopy( void *dst, void far *src, unsigned short len );


void main()
{

    int             i;
    VHAND           prev_vh,
                    vh = VH_NULL;
    NUM_LIST    far *nl;
    char            number[20];

    puts("The pcVMM system will use your \"TMP\" environment variable\n"
        "to determine where to create the virtual swap file. If \"TMP\"\n"
        "is defined in your environment make sure at least 1.5MB is free\n"
        "on the device associated with \"TMP\" for this example.\n"
        "If you wish to abort hit ESC, otherwise any other key to\n"
        "start the example program.");

    if (getch() == 27 )
        exit(1);


    if ((i = open_vmm( NULL )) )
    {
        printf("Error initializing pcVMM #%d.\n", i );
        exit(1);
    }

    printf("\nPerforming %d virtual memory allocations:\n", MAXALLOCS );

    for ( i = 0; i < MAXALLOCS; ++i )
    {
        prev_vh = vh;

        if ( (vh = vmm_alloc( sizeof(NUM_LIST) )) == VH_NULL )
        {
            printf("Error allocating pcVMM on allocation #%d.\n", i );
            exit(1);
        }

        if ( !(nl = vmm_deref( vh )) )
        {
            printf("Error vmm_deref() fail on block #%d\n", i );
            exit(1);
        }

        nl->next = prev_vh;

        (void) itoa( i, number, 10 );

        printf("\r%s", number );

        NearToFarCopy( nl->number, number, sizeof number );
    }

    /* vh == virtual handle pointing to the head of the linked list */

    printf("\nReferencing %d virtual memory allocations:\n", MAXALLOCS );


    for ( i = MAXALLOCS; i >= 0 ; --i )
    {
        if ( !(nl = vmm_deref( vh )) )
        {
            printf("Error vmm_deref() fail on block #%d\n", i );
            exit(1);
        }

        vh = nl->next;  // get next virtual handle

        FarToNearCopy( number, nl->number, sizeof nl->number );

        printf("\r%s", number );

    }

    putchar('\n');

    close_vmm();

    exit(0);
}

static void NearToFarCopy( void far *dst, void *src, register unsigned short len )
{
    unsigned char far       *d = dst;
    register unsigned char  *s = src;

    while (len--)
        *d++ = *s++;
}

static void FarToNearCopy( register void *dst, void far *src, register unsigned short len )
{
    register unsigned char  *d = dst;
    unsigned char  far      *s = src;

    while (len--)
        *d++ = *s++;
}

/* EOF */















