; This code requires Turbo Assembler Version 1.0 or greater. 
; Assembly syntax:
;       TASM /ml /dMDL=<model> PUSHPOP
; where <model> is any one of TINY, SMALL, MEDIUM, COMPACT, LARGE, 
; or HUGE (defaults to small model).

IFNDEF  MDL
        .MODEL  SMALL
ELSE
        .MODEL  MDL
ENDIF

        NOSMART
        .CODE
        PUBLIC  VA_PUSH, VA_POP

VA_PUSH         PROC
        ret                     ; Return leaving argument on stack.
VA_PUSH         ENDP

flush_cache     PROC FAR
        retf
flush_cache     ENDP

VA_POP          PROC
ARG     stksize : WORD

        push    bp
        mov     bp, sp

        mov     ax, stksize     ; Copy pop size to ret instruction.         
        mov     word ptr cs:[retnum], ax

        pop     bp

        call    flush_cache     ; Flush the instruction cache.

        ret     0FFFFh          ; Pop size is dynamically changed.         
        retnum  = $ - 2

VA_POP          ENDP

        END
