/*
  Program:                bin_to_h

  Author:                 Dr. Michael Milligan

  Description:    This program will read a file in binary mode
                  and create a C header file containing the
                  binary data.


  To use:

  bin_to_h source dest

  where source is the name of a binary file to be
  converted, dest is the name of the header file created.

*/

#include <stdio.h>

#define LINE_1 "\t unsigned char bin_data[] = {"
#define LINE_LAST "\n\t};\n"
#define BUFSIZE 512
#define CRLF "\r\n"

void fatal( char * );

void main(int argc, char* argv[] )
{
        FILE *fin, *fout;
        char buf[BUFSIZE], *ch, xch;
        int i, nbytes, col=0;
        long totbytes = 0;

        if (argc != 3) fatal( "bin_to_h source dest\n");

        if ( !(fin  = fopen( argv[1], "rb" ) ) )
                fatal( "Error opening input file.\n") ;
        if ( !(fout = fopen( argv[2], "wb" ) ) )
                fatal( "Error opening output file.\n");

        fprintf( fout, LINE_1 );
        printf("bin_to_h converting...\n");

        while ( nbytes = fread( buf, 1, BUFSIZE, fin ) ) {
          for (i=0; i < nbytes; i++ ) {
               totbytes++;
               if ( !(col++ % 6))
                    fprintf( fout, CRLF "\t\t");
               fprintf( fout, "\'\\x" );
               fprintf( fout, "%02x", (unsigned char) buf[i] );
               fprintf( fout, "\', " );
            }
        }
        fprintf( fout, LINE_LAST );
        fclose( fin );
        fclose( fout );
        printf("\nTotal bytes processed: %ld\n", totbytes);
}

void fatal( char * error)
{
        fprintf( stderr, "%s", error );
        exit( 1 );
}
