{ poly.pas -- Draw a complex filled polygon }

unit Poly;

interface

uses WinTypes, WObjects;

const

  maxPolyPoints = 100;   { Maximum points at 4 bytes each }

type

  PointArray = Array[0 .. maxPolyPoints - 1] of TPoint;

  PPolygon = ^TPolygon;
  TPolygon = object(TObject)
    PA: ^PointArray;    { Pointer to polygon points array }
    Count: Integer;     { Number of points in the array }
    PolyBrush: HBrush;  { Brush pattern for filling polygon }
    constructor Init(NumPoints, XMax, YMax: Integer);
    destructor Done; virtual;
    procedure Draw(DC: HDc); virtual;
  end;

implementation

uses WinProcs;

{ TPolygon }

{- Construct new instance of a randomly ordered polygon }
constructor TPolygon.Init(NumPoints, XMax, YMax: Integer);
var
  I: Integer;
begin
  TObject.Init;
  if NumPoints < 3 then NumPoints := 3;
  GetMem(PA, NumPoints * Sizeof(TPoint));
  if PA = nil then Fail else
  begin
    Count := NumPoints;
    for I := 0 to Count - 1 do with PA^[I] do
    begin
      x := Random(XMax);
      y := Random(YMax)
    end;
    PolyBrush := CreateHatchBrush(hs_DiagCross,
      RGB(Random(255), Random(255), Random(255)))
  end
end;

{- Destroy a TPolygon instance, disposing the PA array }
destructor TPolygon.Done;
begin
  if PA <> nil then FreeMem(PA, Count * Sizeof(TPoint));
  DeleteObject(PolyBrush)  { Delete fill brush }
end;

{- Draw polygon to display context represented by DC }
procedure TPolygon.Draw(DC: HDc);
var
  OldBrush: HBrush;
begin
  if PA <> nil then
  begin
    OldBrush := SelectObject(DC, PolyBrush);
    Polygon(DC, PA^, Count);    { Note dereference! }
    SelectObject(DC, OldBrush);
  end
end;

end.


{--------------------------------------------------------------
  Copyright (c) 1991 by Tom Swan. All rights reserved.
  Revision 1.00    Date: 3/26/1991
---------------------------------------------------------------}
