/*
 * MEDIABYT.C This is a program to determine what size diskette is in drive
 * A: by reading the media byte in the FAT via DOS Interrupt 21h Function 1Ch.
 */

#include <stdio.h>
#include <dos.h>

main()
{
    unsigned char far *fpMediaID;       /* Far pointer to media byte. */
    union REGS sRegs;                   /* Declare registers. */
    struct SREGS sSregs;                /* Declare segment registers. */

    sRegs.h.ah = 0x1C;                  /* Set function to get drive data. */
    sRegs.h.dl = 1;                     /* Set drive id; 0=default, 1=A, etc. */
    intdosx(&sRegs, &sRegs, &sSregs);   /* Execute DOS interrupt. */

    if (sRegs.h.al == 0xFF)
    {
	printf( "Invalid drive or critical error.");
	exit(2);
    }

/* Turn off checks for out of range pointers. (QuickC) */
#pragma check_pointer (off)

/* Pick up segment:offset address of media byte */
    fpMediaID = (unsigned char far *)
	((((long)sSregs.ds) << 16) | sRegs.x.bx);

    printf( "\nMedia byte = %X\n", *fpMediaID);   /* Print media byte. */
    /* The media ID byte has the following meaning:
     *  0xF0    3.5"    double-sided, 18 sectors - 1.44M
     *                  or "other"
     *  0xF8    fixed disk
     *  0xF9    5.25"   double-sided, 15 sectors - 1.2M (AL = 1)
     *          or 3.5" double-sided,  9 sectors - 720K (AL = 2)
     *  0xFC    5.25"   single-sided,  9 sectors - 180K
     *  0xFD    5.25"   double-sided,  9 sectors - 360K
     *  0xFE    5.25"   single-sided,  8 sectors - 160K
     *  0xFF    5.25"   double-sided,  8 sectors - 320K
     */
#pragma check_pointer (on)

    printf ("Capacity = %ld bytes\n",
	    (long)sRegs.x.cx*sRegs.h.al*sRegs.x.dx);

    return (0);
}
