//-------------------------------------------------------------//
// File:   HpFont.Hpp                                          //
// Desc:   Definition for an HP Soft Font Class                //
// Author: Marv Luse, Autumn Hill Software                     //
//-------------------------------------------------------------//

#ifndef _HPFONT_HPP_
#define _HPFONT_HPP_

#include "Font.Hpp"

//........ macro to swap bytes in a 2-byte word

#define REV_WRD( w )  ( ((w>>8) & 0x00FF) | (w<<8) )

//........ constants for categorizing escape sequences

const int eFONTDESC = 1;        // define font descriptor
const int eCHARDESC = 2;        // define char descriptor
const int eCHARCODE = 3;        // specify current char code
const int eUNKNOWN  = 4;        // anything else

//........ constants indicating HP font status

const int hpNOINIT    = 0;      // uninitialized font
const int hpOKAY      = 1;      // all is well
const int hpNOTFOUND  = 101;    // disk file not found
const int hpIOERROR   = 102;    // io error, unexpected eof, etc.
const int hpBADFMT    = 103;    // format failure
const int hpOVRFLOW   = 104;    // internal buffer overflow
const int hpNOMEM     = 105;    // memory allocation failed

//........ font descriptor data structure

struct font_desc
{
    unsigned int   fd_size;        // font descriptor size
             char  resv_1;         // reserved
    unsigned char  font_type;      // font type
             int   resv_2;         // reserved
    unsigned int   bl_dist;        // baseline dist (D)
    unsigned int   cell_width;     // cell width (D)
    unsigned int   cell_height;    // cell height (D)
    unsigned char  orient;         // orientation
    unsigned char  proportional;   // 0=fixed, 1=proportional
    unsigned int   sym_set;        // symbol set
    unsigned int   pitch;          // pitch (QD)
    unsigned int   height;         // height (QD)
    unsigned int   xheight;        // x height (QD)
             char  wid_typ;        // width type
    unsigned char  style;          // style
             char  stroke_weight;  // stroke weight
    unsigned char  typeface;       // typeface
             char  resv_3;         // reserved
    unsigned char  serif_style;    // serif style
             int   resv_4;         // reserved
             char  ul_dist;        // underline dist (D)
    unsigned char  ul_height;      // underline height (D)
    unsigned int   txt_height;     // text height (QD)
    unsigned int   txt_width;      // text width  (QD)
             int   resv_5;         // reserved
             int   resv_6;         // reserved
    unsigned char  pitch_ext;      // pitch extended  (D/1024)
    unsigned char  height_ext;     // height extended (D/1024)
             int   resv_7;         // reserved
             int   resv_8;         // reserved
             int   resv_9;         // reserved
             char  font_name[16];  // font name
};

//........ character descriptor data structure

struct char_desc
{
    unsigned char  format;         // 4 for LaserJet family
             char  continue_flag;  // 0 normally
    unsigned char  desc_size;      // 14 for LaserJet family
    unsigned char  desc_class;     // 1=bitmap, 2=compressed
    unsigned char  orient;         // should match font_dec
             char  resv_1;         // reserved
             int   left_ofs;       // ref pt to bm left (D)
             int   top_ofs;        // ref pt to bm top  (D)
    unsigned int   char_width;     // bitmap width in pixels
    unsigned int   char_height;    // bitmap height in pixels
             int   delta_x;        // ref pt delta (QD)
    //............................... bitmap data follows here
};

//........ HP Soft Font Class

class HpFont : public Font
{
   public:

      int hpstatus;

      HpFont( );
      HpFont( char *path );
     ~HpFont( );

   private:

      void SetFontMetrics( font_desc& fd );
      void SetCharMetrics( Character&, char_desc& fc );
};

#endif
