//-------------------------------------------------------------//
// File:   Font.Cpp                                            //
// Desc:   Methods for Font and Character Classes              //
// Author: Marv Luse, Autumn Hill Software                     //
//-------------------------------------------------------------//

#include "font.hpp"

//........ default constructor

Font::Font( )
{
     fstatus = fntNOINIT;
     cell_w = cell_h = 0;
     ascent = descent = 0;
     pitch = 0;
     ch_cnt = 0;
     min_ch = max_ch = 0;
     ch = 0;
}

//........ constructor that allocates char array

Font::Font( int bgn_ch, int end_ch )
{
     fstatus = fntNOINIT;
     cell_w = cell_h = 0;
     ascent = descent = 0;
     pitch = 0;
     ch_cnt = end_ch - bgn_ch + 1;
     min_ch = bgn_ch;
     max_ch = end_ch;
     ch = new Character[ch_cnt];
     if( ch == 0 )
        fstatus = fntFAILED;
}

//........ destructor

Font::~Font( )
{
     if( ch )
        delete [ch_cnt] ch;
}

//........ compute string width

int Font::strwidth( char *str )
{
     int w = 0;
     while( *str )
     {
        if( (*str >= min_ch) && (*str <= max_ch) )
           w += ch[*str-min_ch].delta_x;
        str++;
     }
     return w;
}

//........ compute actual string height

int Font::strheight( char *str )
{
     int h = 0;
     while( *str )
     {
        if( (*str >= min_ch) && (*str <= max_ch) )
           if( ch[*str-min_ch].height > h )
              h = ch[*str-min_ch].height;
        str++;
     }
     return h;
}

//........ draw a string using Character.draw method

void Font::drawstr( int x, int y, int clr, char *str )
{
     while( *str )
     {
        if( (*str >= min_ch) && (*str <= max_ch) )
        {
           ch[*str-min_ch].drawch( x, y, clr );
           x += ch[*str-min_ch].delta_x;
        }
        str++;
     }
}
