
PROGRAM EnumFunc;
{----------------------------------------------------------------
  This program demonstates the use of a declared enumerated data
  type in a "function-like" call to retrieve the enumeration
  state corresponding to a known ordinal (i.e., it performs the
  inverse of the Ord() function).

  For PC TECHNIQUES by George W. Seaton.
----------------------------------------------------------------}
USES Crt;
{----------------------------------------------------------------
  Define an enumerated data type
----------------------------------------------------------------}
TYPE
  Suit = (Spades,Hearts,Clubs,Diamonds);
VAR
{---------------------------------------------------------------
  MySuit is an instance of type Suit
---------------------------------------------------------------}
  MySuit : Suit;

  N      : Integer;
  Ch     : Char;
  Done   : Boolean;
{==============================================================}
BEGIN
  Done := FALSE;
  ClrScr;
{---------------------------------------------------------------
  Ask the user for a number corresponding to one of the Suit
  states.  As illustrated, it does NOT have to be the exact
  ordinal for the state.
---------------------------------------------------------------}
  WHILE (NOT Done) DO BEGIN
    WriteLn('Enter a suit number (1-4) or zero to quit.');
    WriteLn('(1 = Spades, 2 = Hearts, 3 = Clubs, 4 = Diamonds)');
    REPEAT
      Ch := ReadKey;
    UNTIL (Ch IN ['0'..'4']);
    WriteLn(Ch);
    N := Ord(Ch) - $30;
    IF (N = 0) THEN Done := TRUE
    ELSE BEGIN
{---------------------------------------------------------------
  Set the Enumerated VARIABLE (MySuit) to the proper state by
  creating the ordinal value (N-1) and using it as the parameter
  for the type Suit "function call."
---------------------------------------------------------------}
      MySuit := Suit(N-1);                           (* NOTE! *)
{---------------------------------------------------------------
  Act on the current state of MySuit.
---------------------------------------------------------------}
      Write('You selected ');
      CASE MySuit OF
        Spades   : WriteLn('SPADES!');
        Hearts   : WriteLn('HEARTS!');
        Clubs    : WriteLn('CLUBS!');
        Diamonds : WriteLn('DIAMONDS!');
      END;
    END;
  END;
END.
