//-------------------------------------------------------------//
// File:   Charactr.Hpp                                        //
// Desc:   Definition of a Character Class                     //
// Author: Marv Luse, Autumn Hill Software                     //
//-------------------------------------------------------------//

#ifndef _CHARACTR_HPP_
#define _CHARACTR_HPP_

#include "BitMask.Hpp"

class Font;
class HpFont;

//........ Character Class

class Character : public BitMask
{
      friend class Font;
      friend class HpFont;

   protected:

      int   left_ofs;     // ref-pt to left edge dist
      int   top_ofs;      // ref-pt to top edge dist
      int   delta_x;      // ref-pt to next ref-pt dist

   public:

      Character( );
      Character( int w, int h, char *m );
     ~Character( );
      int  ch_delta( )  { return delta_x; }
      int  ch_width( )  { return width; }
      int  ch_height( ) { return height; }
      virtual void drawch( int x, int y, int clr );
};

#endif
