/* paint.c -- A simple paint program that demonstrates the
 * interactive drawing tools in draw.c. It will automatically
 * use the highest resolution mode available on your system.
 * You can, however, configure it to a specific mode by
 * setting the gmode and gdriver variables to appropriate
 * BGI settings. Note: A mouse is required.
 */
#include <stdio.h>
#include <graphics.h>
#include "draw.h"
#include "mouse.h"

void setupgraphics(void);
void drawscreen(void);
void paint(void);

int main(void) {
  setupgraphics();
  drawscreen();
  if (!initmouse()) {
    closegraph();
    printf("Mouse required.\n");
    exit(1);
  }
  paint();
  closegraph();
  return(0);
}

/* Sets the graphics mode, drawing parameters, and drawing
 * window dimensions.
 */
void setupgraphics(void)
{
  int gmode, gdriver=DETECT, errorcode;

  initgraph(&gdriver, &gmode, "\\tc\\bgi");
  if ((errorcode=graphresult()) != grOk) {
    printf("Graphics error: %s\n", grapherrormsg(errorcode));
    exit(1);
  }
  /* Set the coordinates of the drawing window */
/*  wb = 200;
  wl = 100;
  wr = 500;
  */

  wt = 1;  wb = 400;
  if (wb > getmaxy()-1) wb = getmaxy() - 1;
  wl = textwidth("MenuWidth");
  wr = getmaxx() - 1;

  globaldrawcolor = WHITE;
}

/* Draws the paint program screen. First it sets the screen
 * to blue, then blanks out the drawing window, and finally
 * writes out a menu to the left of the screen.
 */
void drawscreen(void)
{
  setfillstyle(SOLID_FILL, EGA_BLUE);
  bar(0, 0, getmaxx(), getmaxy());
  setfillstyle(SOLID_FILL, EGA_BLACK);
  bar3d(wl-1, wt-1, wr+1, wb+1, 1, 0);
  rectangle(0, 0, wl-1, 120);
  outtextxy(4, 10, "Pencil");   line(0, 20, wl-1, 20);
  outtextxy(4, 30, "SprayCan"); line(0, 40, wl-1, 40);
  outtextxy(4, 50, "Erase");    line(0, 60, wl-1, 60);
  outtextxy(4, 70, "Lines");    line(0, 80, wl-1, 80);
  outtextxy(4, 90, "Circle");   line(0, 100, wl-1, 100);
  outtextxy(4, 110, "Quit");
}

/* The interactive routine that is used to select the
 * various paint routines.
 */
void paint(void)
{
  int x, y;

  while (!buttonstatus(PRESSED,LEFT_BUTTON)) ;
  while (1) {
    while (!buttonstatus(RELEASED,LEFT_BUTTON)) ;
    getmousecoords(&x, &y);
    /* Is the mouse over a menu option? If so, execute
     * its corresponding drawing function.
     */
    if (x < wl && y < 120) {
      if (y < 20) pencil();
      else if (y < 40) spraycan();
      else if (y < 60) erase();
      else if (y < 80) drawlines();
      else if (y < 100) drawcircle();
      else return;  /* Quit option */
    }
    else  /* Flush the extra button press */
      while (!buttonstatus(PRESSED,LEFT_BUTTON)) ;
  }
}
