program Box3dExample;

uses Graph, Crt;

type Style3d = (Concave, Convex);

procedure Box3d(Xul,Yul,Xlr,Ylr,Bw,SunC,ShadowC,FillC:integer;
Bs:Style3d);
{ Draws a 3d box with top-left corner (Xul, Yul) and bottom-right
  corner (Xlr, Ylr), using a border width of Bw, and a border  
style of Bs (either Concave or Convex), using a sun color of  
Sunc, shadow color ShadowC, and interior fill color FillC. } 

var I,T:integer;
begin
  if Bs = Concave then begin { Swap sun and shadow colors }
    T := ShadowC;  ShadowC := SunC;  SunC := T;
  end;
  { For each circuit around the border: }
  for I := 0 to Bw-1 do begin
    SetColor(SunC);
    MoveTo(Xul+I, Ylr-I);     { Draw top/left sides }
    LineTo(Xul+I, Yul+I);
    LineTo(Xlr-I, Yul+I);
    SetColor(ShadowC);
    MoveTo(Xlr-I, Yul+I+1);   { Draw bottom/right sides }
    LineTo(Xlr-I, Ylr-I);
    LineTo(Xul+I+1, Ylr-I);
  end;
  { Fill the interior }
  SetFillStyle(SolidFill,FillC);
  Bar(Xul+Bw, Yul+Bw, Xlr-Bw, Ylr-Bw);
end;

var GDriver, Gmode, ErrCode : integer;
    Ch : Char;

begin
  Gdriver := Detect;
  InitGraph(GDriver,GMode,'c:\tp55');
  ErrCode := GraphResult;
  if ErrCode <> GrOk then begin
    WriteLn('Graphics error: ',GraphErrorMsg(ErrCode));
    Halt(0);
  end;
  Box3d(5, 5, 100, 100, 3, LightCyan, DarkGray, Cyan, Convex);
  Box3d(42, 42, 62, 62, 3, LightCyan, DarkGray, Cyan, Concave);
  Ch := ReadKey;
  CloseGraph;
end.
