/*

	Thread object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#define CLASS Thread

#include "pcoope2.h"
#include "MTask.h"

object CLASS;

extern object DLLink;


#define IN_USE  0x01
#define BLOCKED 0x02
#define CURRENT 0x04

instVars {
	int		stkIndx;
	unsigned char   flags;
	unsigned char   priority;
	jmp_buf  	state;
	 };

INSTANCEPOLY(pAcc);
INSTANCEPOLY(pPause);
INSTANCEPOLY(pReady);
INSTANCEPOLY(pBlock);
INSTANCEPOLY(pUsed);
INSTANCEPOLY(pInUse);
INSTANCEPOLY(pIsBlk);
INSTANCEPOLY(pIsCur);
INSTANCEPOLY(pSetP);
INSTANCEPOLY(pGetP);
INSTANCEPOLY(pGetEl);


cFunc object New(object instance,int stkIndx);
cFunc object Kill(object instance);

iFunc object Acc(object instance);
iFunc object Ready(object instance);
iFunc object Block(object instance);
iFunc object Used(object instance);
iFunc object InUse(object instance);
iFunc object IsBlk(object instance);
iFunc object IsCur(object instance);
iFunc object SetP(object instance, int priority);
iFunc object GetP(object instance);
iFunc object GetEl(object instance);

ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,DLLink,NULL);

MAKE_C_POLY(New);

MAKE_D_POLY(Kill);

MAKE_I_POLY(Acc);
MAKE_I_POLY(Ready);
MAKE_I_POLY(Block);
MAKE_I_POLY(Used);
MAKE_I_POLY(InUse);
MAKE_I_POLY(IsBlk);
MAKE_I_POLY(IsCur);
MAKE_I_POLY(SetP);
MAKE_I_POLY(GetP);
MAKE_I_POLY(GetEl);

ALIAS_POLY(pPause,Schedule);

EndClassInstall;
}



/* DO NOT CALL THIS ROUTINE, USED ONLY BY MTASK ROUTINES */

cFunc object New(object instance, int stkIndx)
{
DECLAREivPtr;
BEGIN_NEW;
MakeInstance;

pNew(DLLink,NULL,NULL);
ivPtr->stkIndx=stkIndx;
ivPtr->priority=LOW_PRIORITY;

END_NEW;
}


iFunc object Acc(object instance)
{
GETIVPTR;
return (ivPtr->state);
}

iFunc object GetEl(object instance)
{
return (object) ((cast) IVPTR->stkIndx);
}


iFunc object Ready(object instance)
{
IVPTR->flags ^= CURRENT;
return instance;
}

iFunc object Used(object instance)
{
GETIVPTR;
ivPtr->flags |= IN_USE;
return instance;
}

iFunc object Block(object instance)
{
IVPTR->flags ^=BLOCKED;
return instance;
}

iFunc object IsCur(object instance)
{
return (object) ((cast) IVPTR->flags & CURRENT);
}

iFunc object InUse(object instance)
{
return (object) ((cast) IVPTR->flags & IN_USE);
}

iFunc object IsBlk(object instance)
{
return (object) ((cast) IVPTR->flags & BLOCKED);
}

iFunc object SetP(object instance,int priority)
{
IVPTR->priority=priority;
return instance;
}

iFunc object GetP(object instance)
{
return (object) ((cast) IVPTR->priority);
}


cFunc object Kill(object instance)
{
GETIVPTR;

if(ivPtr->flags & CURRENT)
    {
    ivPtr->flags = 0;
    Schedule(NULL);
    }
return NULL;
}


