/*

	Ptr (pointer) object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/

#define CLASS Ptr

#include "pcoope2.h"
#include <stdio.h>

object CLASS;

clsVars {char ascii[16];};

instVars {object pointer;};

INSTANCEPOLY(pAcc);
INSTANCEPOLY(pSet);
INSTANCEPOLY(pToStd);
INSTANCEPOLY(pToAlt);
INSTANCEPOLY(pGetESz);
INSTANCEPOLY(pPut);

INCLUDEPOLY(pPuts);

cFunc object New(object instance,object pointer);
iFunc object Set(object instance,object newPtr);
iFunc object Acc(object instance);
iFunc object ToStd(object instance);
iFunc object ToAlt(object instance);
iFunc object GetESz(object instance);
iFunc object Put(object instance, object stream);

ClassInstallFunc
{
pNew(Base,sizeof(clsVars),sizeof(instVars),&CLASS,NULL);

MAKE_C_POLY(New);
MAKE_I_POLY(Acc);
MAKE_I_POLY(Set);
MAKE_I_POLY(ToStd);
MAKE_I_POLY(ToAlt);
MAKE_I_POLY(GetESz);
MAKE_I_POLY(Put);

EndClassInstall;
}


#define pPuts I_POLY(pPuts)

cFunc object New(object instance,object pointer)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;
ivPtr->pointer = pointer;

END_NEW;
}


iFunc object Acc(object instance)
{
GETIVPTR;
return &(ivPtr->pointer);
}


iFunc object Set(object instance,object newPtr)
{
IVPTR->pointer=newPtr;

return instance;
}


iFunc object ToStd(object instance)
{
GETIVPTR;
GETCVPTR;

sprintf(cvPtr->ascii,"%p",ivPtr->pointer);

return &(cvPtr->ascii);
}


iFunc object ToAlt(object instance)
{
return ToStd(instance);
}


iFunc object Put(object instance, object stream)
{
GETCVPTR;

ToStd(instance);
if((cast)EOF==(cast) pPuts(stream,cvPtr->ascii)) return NULL;
return Base;
}

#pragma warn -par

iFunc object GetESz(object instance)
{
return (object) ((cast) sizeof(void *));
}

#pragma warn +par
