/*

    POLYMORPHING C-LANGUAGE OBJECT ORIENTED PROGRAMMING EXTENSION VER 2.0

		BASIC TEST ROUTINES

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/

#include "pcoope2.h"	/* ALWAYS INCLUDE THE PCOOPE HEADER FILE */


#include <alloc.h>    /* LOCAL INCLUDES FOR TEST ROUTINE */
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>






/*
**  initialize the polymorphs and object classes
*/

#include "polyini.h"

object safeHnd;
object task1hnd;
object task2hnd;

object pipe1=NULL;
object pipe2=NULL;

object s,t;
object STDOUT;

void safety(void);
void taskone(void);
void tasktwo(void);


/*
**   POLYMORPH C-LANGUAGE OBJECT ORIENTED PROGRAMMING EXTENSION TEST
*/

int main (void)
{
object x;

polyInit();	/* call the class initializer routine */


	  /* basic hello world and base object test */


STDOUT=pNew(StdStrm,stdout);
makePerm(STDOUT);

x=pNew(String,"\n\nHello World!");
pPut(x,STDOUT);


	/* setup for persistant object test */

t=pNew(String,"\nStill Here !!!!");
makePerm(t);


pPut(pNew(String,"\n\n HIT ANY KEY TO CONTINUE  \n"),STDOUT);
while(!kbhit());


/* setup multi tasking system */

MTaskIni();

InstTask(safety,2);
InstTask(taskone,1);
InstTask(tasktwo,1);

task1hnd=GetTask(taskone);
task2hnd=GetTask(tasktwo);
safeHnd=GetTask(safety);

/* begin multi tasking */

Schedule(NULL);

return 1;
}


void safety(void)
{
for(;;)
    {
    pPause(safeHnd);
    }
}


void taskone(void)
{
char buffer[16];
object x,y,v;
long z;
object wrHnd;
object rdHnd;


pipe1=pNew(Pipe,16);
pipe2=pNew(Pipe,16);

wrHnd=pGetWr(pipe1);
rdHnd=pGetRd(pipe2);

pWait(pipe1,task1hnd);
pSetPos(wrHnd,0L);
pPuts(wrHnd,pToStd(pNew(LInt,1L)));
pSignal(pipe1,task1hnd);

for(;;)
    {
    pPause(task1hnd);
    pWait(pipe2,task1hnd);
    pSetPos(rdHnd,0L);
    if(NULL==pGets(rdHnd,buffer,15)) z=0;
    else z=atol(buffer);
    pSignal(pipe2,task1hnd);
    if(z==0) continue;
    if(z%2) continue;

	/* setup for non-persistant object retainment test */
    v=pNew(String,"!!!");


	/* garbage collector memory core usage test */

    x=pNew(String,"\nPass number: ");
    pPut(x,STDOUT);
    y=pNew(LInt,z);
    pPut(y,STDOUT);
    x=pNew(String,"      mem left: ");
    y=pNew(LInt,(long) (coreleft()>>4));
    x=pAdd(x,pToAlt(y));
    pPut(pAdd(x," Paragraphs.    "),STDOUT);

    if(!(z%180))        /* intermittant memory usage test */
	{
	while(NULL==(s=malloc(30000)))
	    {
	    pErrNum=pErrOUTOFMEM;
	    pErr(t);
	    }
	}
    if(!((z-90)%180) && z>100)
	{
	free(s);
	}

	 /* test for retainment of non-persistant object */

    pPut(v,STDOUT); /*  gives error if v freed */

    if((z%1000)==0)          /* persistant object test */
	{
	pPut(t,STDOUT);
	}
    pWait(pipe1,task1hnd);
    pSetPos(wrHnd,0L);
    pPuts(wrHnd,pToStd(pNew(LInt,z+1)));
    pSignal(pipe1,task1hnd);
    }
}


void tasktwo(void)
{
char buffer[16];
object x,y,v;
long z;
object wrHnd;
object rdHnd;


if(pipe1==NULL) pPause(task2hnd);
rdHnd=pGetRd(pipe1);
wrHnd=pGetWr(pipe2);

for(;;)
    {
    pPause(task2hnd);
    pWait(pipe1,task2hnd);
    pSetPos(rdHnd,0L);
    if(NULL==pGets(rdHnd,buffer,15)) z=0;
    else z=atol(buffer);
    pSignal(pipe1,task2hnd);
    if(!(z%2)) continue;

	/* setup for non-persistant object retainment test */
    v=pNew(String,"!!!");


	/* garbage collector memory core usage test */

    x=pNew(String,"\nPass number: ");
    pPut(x,STDOUT);
    y=pNew(LInt,z);
    pPut(y,STDOUT);
    x=pNew(String,"      mem left: ");
    y=pNew(LInt,(long) (coreleft()>>4));
    x=pAdd(x,pToAlt(y));
    pPut(pAdd(x," Paragraphs.    "),STDOUT);

	 /* test for retainment of non-persistant object */

    pPut(v,STDOUT);  /* gives error if v freed */

    pWait(pipe2,task2hnd);
    pSetPos(wrHnd,0L);
    pPuts(wrHnd,pToStd(pNew(LInt,z+1)));
    pSignal(pipe2,task2hnd);
    }
}

