
/**************************************************************************
*                                                                         *
*		header for pcoope2 -                                      *
*                                                                         *
*   polymorphing c-language object oriented programming extension ver 2.1 *
*                                                                         *
*	Copyright (C) Brian Lee Price, 1994.                              *
*                                                                         *
*	  A product of Price Technologies    				  *
*                                                                         *
*       released as PUBLIC DOMAIN software 4/25/94                        *
*                                                                         *
*	ANSI-C CODE 8 CHARACTER IDENTIFIER COMPATIBLE                     *
*                                                                         *
**************************************************************************/

#ifndef _PCOOPE_HEADER_
#define _PCOOPE_HEADER_

#include <stddef.h>
#include <stdarg.h>

typedef 	void * 		object;
typedef 	unsigned char 	byte;
typedef 	unsigned int 	dSizeT;
typedef 	object 		(*pType)();

typedef struct PRCDtype {
	object		class;
	object		owner;
	pType		pRtn;
	} pRcdType;

typedef struct {
	object		*pRoot;
	int		*pNAlias;
	pType		pRtn;
	} aliasLst;

typedef struct {
	object		class;
	int		numAlias;
	aliasLst *	aliases;
	} classAli;

typedef struct {
	dSizeT   	ivSize,
			numPar;
	} clsType;

typedef struct {
	int		lastAcc;
	unsigned int	verify;
	object		class,
			child;
	} instType;

#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#define NEAR_DATA_POINTERS
#define Base ((object)0xFFFF)
#define MAX_VAL (0x7FFF)
#define cast int
#else
#define FAR_DATA_POINTERS
#define Base ((object)0xFFFFFFFFL)
#define MAX_VAL (0x7FFFFFFFL)
#define cast long
#endif

enum pErrType {pErrOK,pErrBADALIAS,pErrOUTOFMEM,pErrBADINSTANCE,
					pErrFATALDATA,pErrBADCLASS};

#ifdef _INTERNAL_

char *pErrText[6]={{"No error reported"},
		   {"Bad Alias for polymorph function"},
		   {"Memory Allocation Error Timeout"},
		   {"Bad object Instance"},
		   {"Fatal internal dataBase error"},
		   {"Bad object Class"}};
object 	pNewPR=NULL;
int	pNewNA=0;
object 	pKillPR=NULL;
int	pKillNA=0;
object 	pErrPR=NULL;
int 	pErrNA=0;
enum 	pErrType pErrNum=pErrOK;
object 	curInst=NULL;
object  curChild=NULL;
object 	curClass=NULL;

#else
extern char *	pErrText[];
extern object 	pKillPR;
extern int 	pKillNA;
extern object 	pNewPR;
extern int 	pNewNA;
extern object 	pErrPR;
extern int 	pErrNA;
extern enum 	pErrType pErrNum;
extern object 	curInst;
extern object 	curChild;
extern object 	curClass;

#endif


/* garbage collector and error control defines */

#ifndef MAXINT
#define MAXINT (0x7FFF)
#endif                           /* objects are born old and die young */

#define INITAGE (1000)                  /* initial object age */
#define MAXNUMOBJECTS ((MAXINT/2)-2)    /* max number of objects in can */
#define TIMVAL (1000)                   /* time out slows down trashman */
#define MINDCRVAL (32)	    	        /* the minimum age decrement */
#define MAXDCRVAL (249)			/* the maximum age decrement */
#define MINSHIFTVAL (0)		/* sets max no. objects checked per call */
#define MAXSHIFTVAL (8)		/* sets min no. objects checked per call */
#define MAXERRTRYS (MAXINT)     /* maximum no. of calls prior to error */


/* function prototypes */

void   addPFunc(object class, object *pRoot, int *NAlias, pType newMorph);

pType  pLookUp(pRcdType * pRoot,int NAlias,...);

pType  CpLookUp(pRcdType * pRoot,int NAlias,pType baseRtn,...);

pType  DpLookUp(pRcdType * pRoot,int NAlias,pType dfltRtn,...);

pType  getMorph(pRcdType * pRoot,int NAlias,object * instance);

object newClass(object class,...);

object killInst(object instance,...);

object memErr(void);

void   rcsAlias(object parent, object class);

void   rmvAlias(void);

object makePart(object instance, object ancInst);

void   makePerm(object instance);

object polyNull(object instance,...);

object makeInst(object className,object * newInst);

void   addPRcd(object class,object owner,
		object *pRoot, int * NAlias, pType morph);

object rcsAinst(object aClass,object instance);

object getAinst(object aClass,object instance);

object getApath(object instance,...); /* get anc by NULL terminated path */


/* begin pcoope-user defines */

#define Concat(x,y) x##y
#define cFunc static
#define iFunc static
#define instVars struct InstVars
#define clsVars struct ClsVars

#define VALIDATE(obj)\
if(((((instType *) obj)->verify)^(~((unsigned int) obj))))\
{pErrNum=pErrBADINSTANCE;return pErr(Base);}\
else {if( ((instType *)obj)->lastAcc<INITAGE)\
((instType *) obj)->lastAcc=INITAGE;}

#define BEGIN_NEW object oldClass;object oldInst;\
oldClass=curChild=curClass;curClass=CLASS;oldInst=curInst;

#define END_NEW curClass=oldClass;curInst=oldInst;return instance;

#define SetivSz(cls,newSz) ((clsType *) cls)->ivSize=newSz

#define SETIVSIZE(size) SetivSz(CLASS,size)

#define DECLAREivPtr  instVars *ivPtr

#define MakeInstance ivPtr=(instVars *)makeInst(CLASS,&(instance))

#define MAKEINST makeInst(CLASS,&instance)

#define FindivPtr(cls,inst,ptr)\
{object locInst=getAinst(cls,inst);\
if(locInst==NULL){pErrNum=pErrFATALDATA;pErr(instance);}\
else (byte *)ptr=(byte *)locInst+sizeof(instType)\
+((clsType *) cls)->numPar*sizeof(object);}

#define GetivPtr (byte *)ivPtr=(byte *)instance+sizeof(instType)\
+sizeof(object)*((clsType *)CLASS)->numPar

#define GETIVPTR instVars * ivPtr=(instVars *) ((byte *) instance +\
sizeof(instType)+sizeof(object)*((clsType *)CLASS)->numPar)

#define IVPTR ((instVars *) ((byte *) instance + sizeof(instType) +\
sizeof(object)*((clsType *)CLASS)->numPar))

#define DECLAREcvPtr clsVars * cvPtr

#define FindcvPtr(cls,ptr)\
(byte *) ptr=(byte *)cls+sizeof(clsType)\
+((clsType *)cls)->numPar*sizeof(object)

#define GetcvPtr (byte *)cvPtr=(byte *)CLASS + sizeof(clsType) +\
((clsType *)CLASS)->numPar*sizeof(object)

#define GETCVPTR clsVars * cvPtr=(clsVars *) ((byte *) CLASS +\
sizeof(clsType)+((clsType *)CLASS)->numPar*sizeof(object))

#define CVPTR ((clsVars *) ((byte *) CLASS+sizeof(clsType)+\
((clsType *)CLASS)->numPar*sizeof(object)))

#define GETDIRECT(NamSans_p,instPtr)\
getMorph(Concat(p,Concat(NamSans_p,PR)),\
Concat(p,Concat(NamSans_p,NA)),instPtr)

#define I_POLY(pNam) (pLookUp(Concat(pNam,PR),Concat(pNam,NA)))

#define C_POLY(pNam,bRtn) (CpLookUp(Concat(pNam,PR),Concat(pNam,NA),bRtn))

#define D_POLY(pNam,dRtn) (DpLookUp(Concat(pNam,PR),Concat(pNam,NA),dRtn))

#define DECLARE_POLY(pNam) pRcdType * Concat(pNam,PR);int Concat(pNam,NA);

#define pNew C_POLY(pNew,newClass)

#define pKill D_POLY(pKill,killInst)

#define pErr D_POLY(pErr,memErr)

#define EXTERNPOLY(pName)\
extern object Concat(pName,PR);\
extern int Concat(pName,NA)

#define INSTANCEPOLY(pName) EXTERNPOLY(pName);

#define INCLUDEPOLY(pName) EXTERNPOLY(pName)

#define EXCLUDEPOLY(pName) EXTERNPOLY(pName)

#define MAKE_I_POLY(morph)\
addPFunc(CLASS,&(Concat(p,Concat(morph,PR))),\
&(Concat(p,Concat(morph,NA))), morph)

#define MAKE_C_POLY(morph)\
addPRcd(CLASS,CLASS,&(Concat(p,Concat(morph,PR))),\
&(Concat(p,Concat(morph,NA))),morph)

#define MAKE_D_POLY(morph) MAKE_I_POLY(morph)

#define ALIAS_POLY(pNam,morph)\
addPFunc(CLASS,&(Concat(pNam,PR)),&(Concat(pNam,NA)), morph)

#define EXCLUDE_POLY(pName)\
addPFunc(CLASS,&(Concat(pName,PR)),\
&(Concat(pName,NA)),polyNull)

#define ClassInstallFunc void Concat(CLASS,_Install) (void)

#define EndClassInstall rcsAlias(CLASS,CLASS)

#define INSTALL_CLASS(cName) Concat(cName,_Install)()

#define END_INIT rmvAlias()

#define DECLARE_CLASS(cName) void Concat(cName,_Install)(void);\
extern object cName

#endif

/* end of pcoope2 header file */
