
/*

	Stream object class definition for PCOOPE2

	This class is for stream interface to user defined i/o objects

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#define CLASS Stream

#include "pcoope2.h"
#include "stream.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

object CLASS;


clsVars {
	unsigned char	fbuf[FORMAT_BUFFER_SIZE];
	};

instVars {
	object		ioObj;
	unsigned char * buffer;
	unsigned char	hold;
	short int	bsize;
	short int	curPos;
	unsigned	flags;
	 };


INSTANCEPOLY(pGetPos);
INSTANCEPOLY(pSetPos);
INSTANCEPOLY(pStat);
INSTANCEPOLY(pClrErr);
INSTANCEPOLY(pPutc);
INSTANCEPOLY(pGetc);
INSTANCEPOLY(pUnGet);
INSTANCEPOLY(pPuts);
INSTANCEPOLY(pGets);
INSTANCEPOLY(pPrint);
INSTANCEPOLY(pWrite);
INSTANCEPOLY(pRead);


cFunc object New(object instance, object ioObj,	const char * mode);

iFunc object GetPos(object instance);
iFunc object SetPos(object instance, long newPos);
iFunc object Stat(object instance);
iFunc object ClrErr(object instance);
iFunc object Putc(object instance, char c);
iFunc object Getc(object instance);
iFunc object UnGet(object instance, char c);
iFunc object Puts(object instance, const char * s);
iFunc object Gets(object instance, char *d, int max);
iFunc object Print(object instance, const char * format,...);
iFunc object Write(object instance, const char * ptr, size_t size, size_t n);
iFunc object Read(object instance, char * ptr, size_t size, size_t n);


ClassInstallFunc
{
pNew(Base,sizeof(clsVars),sizeof(instVars),&CLASS,NULL);

MAKE_C_POLY(New);

MAKE_I_POLY(GetPos);
MAKE_I_POLY(SetPos);
MAKE_I_POLY(Stat);
MAKE_I_POLY(ClrErr);
MAKE_I_POLY(Putc);
MAKE_I_POLY(Getc);
MAKE_I_POLY(UnGet);
MAKE_I_POLY(Puts);
MAKE_I_POLY(Gets);
MAKE_I_POLY(Print);
MAKE_I_POLY(Write);
MAKE_I_POLY(Read);

EndClassInstall;
}


#define pGetc 	I_POLY(pGetc)
#define pPutc 	I_POLY(pPutc)
#define pGetPos I_POLY(pGetPos)
#define pSetPos I_POLY(pSetPos)
#define pClrErr I_POLY(pClrErr)


cFunc object New(object instance, object ioObj, const char * mode)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;

ivPtr->ioObj=ioObj;
ivPtr->flags=S_BIN;
if(NULL!=strchr(mode,'r')) ivPtr->flags |= S_READ;
if(NULL!=strchr(mode,'w')) ivPtr->flags |= S_WRITE;
if(NULL!=strchr(mode,'t')) ivPtr->flags &= ~S_BIN;
if(NULL!=strchr(mode,'+')) ivPtr->flags |= S_RDWR;

END_NEW;
}


iFunc object SetBuf(object instance,char * buffer, int type, size_t size)
{
GETIVPTR;

if(ivPtr->buffer != NULL || size<=0) return Base;
if(type==_IONBF) return NULL;
ivPtr->buffer=(unsigned char *)buffer;
ivPtr->bsize=size;
ivPtr->flags|=S_BUF;
if(type==_IOLBF) ivPtr->flags|=S_LBUF;
return NULL;
}


iFunc object Flush(object instance)
{
pType wrDest;
unsigned char * ptrA;
GETIVPTR;

if(ivPtr->flags & S_WRITE && ivPtr->curPos>0)
    {
    wrDest=GETDIRECT(Putc,&(ivPtr->ioObj));
    for(ptrA=ivPtr->buffer;ivPtr->curPos>0;ivPtr->curPos--,ptrA++)
	{
	if((cast)EOF==((cast) wrDest(ivPtr->ioObj,*ptrA)))
	    {
	    ivPtr->flags |= S_EOS;
	    return (object) ((cast) EOF);
	    }
	}
    }
else ivPtr->curPos=0;
ivPtr->hold=0;
return (object) ((cast) ivPtr->curPos);
}


static int fillBuff(object instance)
{
int x;
pType rdSrc;
GETIVPTR;

rdSrc=GETDIRECT(Getc,&(ivPtr->ioObj));
for(ivPtr->curPos=0;ivPtr->curPos<ivPtr->bsize;ivPtr->curPos++)
    {
    if(EOF==(x=*((int *) rdSrc(ivPtr->ioObj)))) return x;
    (unsigned char)ivPtr->buffer[ivPtr->curPos++]=x;
    }
ivPtr->curPos=0;
return x;
}


iFunc object GetPos(object instance)
{
cast rv;
GETIVPTR;

Flush(instance);
if((cast)EOF==(cast)Flush(instance))
    {
    rv = ((cast) -1);
    }
else
    {
    rv=((cast) pGetPos(ivPtr->ioObj));
    if(rv<0) ivPtr->flags |= S_ERR;
    }
return (object) rv;
}


iFunc object SetPos(object instance, long newPos)
{
cast rv;
GETIVPTR;

rv=(cast) Flush(instance);
if((cast)EOF != rv)
    {
    if(newPos==0) ivPtr->flags &= (S_RDWR | S_BUF | S_LBUF | S_BIN);
    else ivPtr->flags &= (S_RDWR | S_BUF | S_LBUF | S_BIN | S_ERR);
    if((cast)EOF==(rv=((cast) pSetPos(ivPtr->ioObj))))
	ivPtr->flags|=S_EOS;
    }
else ivPtr->flags |= S_ERR;
return (object) rv;
}


iFunc object ClrErr(object instance)
{
GETIVPTR;

pClrErr(ivPtr->ioObj);
ivPtr->flags&=(S_RDWR | S_BUF | S_LBUF | S_BIN);
return instance;
}


iFunc object Stat(object instance)
{
GETIVPTR;
return (object) ((cast) ivPtr->flags);
}


iFunc object Putc(object instance, char c)
{
cast rv;
GETIVPTR;

rv=(cast)EOF;
if(OKAY_W)
    {
    if(c=='\n' && !(ivPtr->flags & S_BIN))
	{
	Putc(instance,'\r');
	}
    SET_W;
    if(ivPtr->flags & S_BUF)
	{
	if(ivPtr->curPos>=ivPtr->bsize)
	    {
	    if((cast)Flush(instance)==(cast)EOF) goto done;
	    }
	rv=(cast)((unsigned char)ivPtr->buffer[ivPtr->curPos++]=c);
	if(c=='\n' && ivPtr->flags&S_LBUF)
	    {
	    Flush(instance);
	    }
	}
    else rv=((cast)pPutc(ivPtr->ioObj,c));
    if(rv==(cast)EOF) ivPtr->flags|=S_EOS;
    }
else ivPtr->flags|=S_ERR;
done:
return (object) rv;
}


iFunc object Getc(object instance)
{
cast rv;
GETIVPTR;

restart:
rv=(cast)EOF;
if(OKAY_R)
    {
    if(ivPtr->flags & S_BUF)
	{
	if(!(ivPtr->flags & S_IN) || ivPtr->curPos>=ivPtr->bsize)
	    {
	    SET_R;
	    if((cast)EOF==(rv=(cast) fillBuff(instance))) goto done;
	    }
	rv=(cast)((unsigned char)ivPtr->buffer[ivPtr->curPos++]);
	}
    else
	{
	SET_R;
	if(ivPtr->hold!=0)
	    {
	    rv=ivPtr->hold;
	    ivPtr->hold=0;
	    }
	else rv=((cast)pGetc(ivPtr->ioObj));
	}
    if(rv==(cast)EOF) ivPtr->flags |= S_EOS;
    }
else ivPtr->flags |= S_ERR;
done:
if((unsigned char)rv=='\r' && !(ivPtr->flags&S_BIN))goto restart;
return (object) rv;
}



iFunc object UnGet(object instance, char c)
{
cast rv;
GETIVPTR;

rv=(cast)EOF;
if(OKAY_R && ivPtr->flags & S_IN)
    {
    if(ivPtr->flags&=S_BUF)
	{
	if(ivPtr->curPos>0)
	rv=(cast)((unsigned char)ivPtr->buffer[--ivPtr->curPos]=c);
	}
    else rv=(cast)((unsigned char)ivPtr->hold=c);
    }
if(rv==(cast)EOF) ivPtr->flags|=S_ERR;
return (object) rv;
}



iFunc object Puts(object instance, const char * s)
{
cast rv=(cast)EOF;
int x=0;
pType direct;
GETIVPTR;

if(OKAY_W && s!=NULL)
    {
    SET_W;
    if(ivPtr->flags & S_BUF)
	{
	while(s[x]!=0)
	    {
	    if(s[x]=='\n' && !(ivPtr->flags&S_BIN))
		{
		rv=(cast) Putc(instance,'\r');
		}
	    if(ivPtr->curPos>=ivPtr->bsize)
		{
		if((cast)Flush(instance)==(cast)EOF)
		    {
		    rv=(cast)EOF;
		    break;
		    }
		}
	    rv=(cast)((unsigned char)ivPtr->buffer[ivPtr->curPos++]=s[x]);
	    if(s[x]=='\n' && ivPtr->flags&S_LBUF && ivPtr->curPos>0)
		{
		if((cast)Flush(instance)==(cast)EOF)
		    {
		    rv=(cast)EOF;
		    break;
		    }
		}
	    x++;
	    }
	}
    else
	{
	direct=GETDIRECT(Putc,&(ivPtr->ioObj));
	while(s[x]!=0)
	    {
	    if(s[x]=='\n' && !(ivPtr->flags&S_BIN))
		{
		if((cast)EOF==(rv=(cast) direct(ivPtr->ioObj,'\r')))
		   break;
		}
	    if((cast)EOF==(rv=(cast) direct(ivPtr->ioObj,s[x++])))
		break;
	    }
	}
    if(rv==(cast)EOF) ivPtr->flags |= S_EOS;
    }
else ivPtr->flags |= S_ERR;
return (object) rv;
}


iFunc object Gets(object instance, char *d, int max)
{
int x=0;
cast rv=(cast)EOF;
pType direct;
GETIVPTR;

if(OKAY_R && d!=NULL)
    {
    if(ivPtr->flags & S_BUF)
	{
	rv=0;
	if(!(ivPtr->flags & S_IN) || ivPtr->curPos>=ivPtr->bsize)
	    {
	    SET_R;
	    if((cast)EOF==(rv=fillBuff(instance))) x=max;
	    }
	while(x<max-1)
	    {
	    d[x]=(unsigned char)ivPtr->buffer[ivPtr->curPos++];
	    if(ivPtr->curPos>=ivPtr->bsize)
	    if((cast)EOF==(rv=fillBuff(instance))) break;
	    if(d[x]=='\r' && !(ivPtr->flags&S_BIN)) continue;
	    if(d[x++]=='\n') break;
	    }
	d[x]=0;
	}
    else
	{
	SET_R;
	direct=GETDIRECT(Getc,&(ivPtr->ioObj));
	while(x<max-1)
	    {
	    if((cast)EOF==(rv=(cast)direct(ivPtr->ioObj)))
		break;
	    if((d[x]=(unsigned char) rv)=='\r'
		&& !(ivPtr->flags&S_BIN)) continue;
	    if(d[x++]=='\n') break;
	    }
	d[x]=0;
	}
    if(rv==(cast)EOF)
	{
	ivPtr->flags|=S_EOS;
	return NULL;
	}
    return d;
    }
ivPtr->flags|=S_ERR;
return NULL;
}


iFunc object Write(object instance, const char * ptr, size_t size, size_t n)
{
pType direct;
size_t x,max;
cast rv=0;
GETIVPTR;

if(OKAY_W && ptr != NULL && size > 0 && n > 0)
    {
    SET_W;
    if(ivPtr->flags & S_BUF)
	{
	for(x=0,max=size*n;x<max;x++)
	    {
	    if(ptr[x]=='\n' && !(ivPtr->flags&S_BIN))
		{
		Putc(instance,'\r');
		}
	    if(ivPtr->curPos>=ivPtr->bsize)
		{
		if((rv=(cast)Flush(instance))==(cast)EOF) break;
		}
	    (unsigned char)ivPtr->buffer[ivPtr->curPos++]=ptr[x];
	    if(ptr[x]=='\n' && ivPtr->flags&S_LBUF && ivPtr->curPos>0)
		{
		if((rv=(cast)Flush(instance))==(cast)EOF) break;
		}
	    }
	}
    else
	{
	direct=GETDIRECT(Putc,&(ivPtr->ioObj));
	for(x=0,max=size*n;x<max;x++)
	    {
	    if(ptr[x]=='\n' && !(ivPtr->flags&S_BIN))
		{
		if((cast)EOF==(rv=(cast)direct(ivPtr->ioObj,'\r')))
		   break;
		}
	    if((cast)EOF==(rv=(cast)direct(ivPtr->ioObj,ptr[x])))
		break;
	    }
	}
    if((cast)EOF==rv) ivPtr->flags|=S_EOS;
    rv=(max>x)?(cast)x:(cast)max;
    }
else ivPtr->flags|=S_ERR;

return (object) rv;
}



iFunc object Read(object instance, char * ptr, size_t size, size_t n)
{
size_t x,max;
pType direct;
cast rv=0;
GETIVPTR;

if(OKAY_R && ptr != NULL && size > 0 && n > 0)
    {
    if(ivPtr->flags & S_BUF)
	{
	if(!(ivPtr->flags & S_IN) || ivPtr->curPos>=ivPtr->bsize)
	    {
	    SET_R;
	    if((cast)EOF==(rv=fillBuff(instance))) size=0;
	    }
	for(x=0,max=size*n;x<max;x++)
	    {
	    ptr[x]=(unsigned char)ivPtr->buffer[ivPtr->curPos++];
	    if(ivPtr->curPos>=ivPtr->bsize)
	    if((cast)EOF==(rv=fillBuff(instance))) break;
	    if(ptr[x]=='\r' && !(ivPtr->flags&S_BIN))
		{
		x--;
		continue;
		}
	    }
	}
    else
	{
	SET_R;
	direct=GETDIRECT(Getc,&(ivPtr->ioObj));
	for(x=0,max=size*n;x<max;x++)
	    {
	    if((cast)EOF==(rv=(cast) direct(ivPtr->ioObj)))
		break;
	    if((ptr[x]=(unsigned char) rv)=='\r'
		&& !(ivPtr->flags&S_BIN))
		{
		x--;
		continue;
		}
	    }
	}
    if(rv==(cast)EOF)
	{
	ivPtr->flags|=S_EOS;
	}
    rv=(x<max)?(cast)x:(cast)max;
    }
else ivPtr->flags|=S_ERR;
return (object) rv;
}



iFunc object Print(object instance, const char * format,...)
{
int y;
cast rv=(cast)EOF;
va_list ap;
GETIVPTR;
GETCVPTR;

if(OKAY_W && format!=NULL)
    {
    va_start(ap,format);
    if(EOF!=(y=vsprintf((char *) cvPtr->fbuf,format,ap)))
	{
	if((cast)EOF!=(rv=(cast)Puts(instance,(char *) cvPtr->fbuf)))
	    rv=y;
	}
    va_end(ap);
    }
else ivPtr->flags|=S_ERR;
return (object) rv;
}



