
/*

	StdStrm object class definition for PCOOPE2

	This class is for stream interface to standard ANSI-C streams

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#define CLASS StdStrm

#include "pcoope2.h"
#include "stream.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

object CLASS;


instVars {
	FILE *		stream;
	unsigned	flags;
	 };


INSTANCEPOLY(pGetPos);
INSTANCEPOLY(pSetPos);
INSTANCEPOLY(pStat);
INSTANCEPOLY(pClrErr);
INSTANCEPOLY(pPutc);
INSTANCEPOLY(pGetc);
INSTANCEPOLY(pUnGet);
INSTANCEPOLY(pPuts);
INSTANCEPOLY(pGets);
INSTANCEPOLY(pPrint);
INSTANCEPOLY(pScan);
INSTANCEPOLY(pWrite);
INSTANCEPOLY(pRead);
INSTANCEPOLY(pAcc);


cFunc object New(object instance, FILE * fStream);

iFunc object GetPos(object instance);
iFunc object SetPos(object instance, long newPos);
iFunc object Stat(object instance);
iFunc object ClrErr(object instance);
iFunc object Putc(object instance, char c);
iFunc object Getc(object instance);
iFunc object UnGet(object instance, char c);
iFunc object Puts(object instance, const char * s);
iFunc object Gets(object instance, char *d, int max);
iFunc object Print(object instance, const char * format,...);
iFunc object Scan(object instance, const char * format,...);
iFunc object Write(object instance, const char * ptr, size_t size, size_t n);
iFunc object Read(object instance, char * ptr, size_t size, size_t n);
iFunc object Acc(object instance);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,NULL);

MAKE_C_POLY(New);

MAKE_I_POLY(GetPos);
MAKE_I_POLY(SetPos);
MAKE_I_POLY(Stat);
MAKE_I_POLY(ClrErr);
MAKE_I_POLY(Putc);
MAKE_I_POLY(Getc);
MAKE_I_POLY(UnGet);
MAKE_I_POLY(Puts);
MAKE_I_POLY(Gets);
MAKE_I_POLY(Print);
MAKE_I_POLY(Scan);
MAKE_I_POLY(Write);
MAKE_I_POLY(Read);
MAKE_I_POLY(Acc);

EndClassInstall;
}



cFunc object New(object instance, FILE * fStream)
{
DECLAREivPtr;
BEGIN_NEW;

MakeInstance;

ivPtr->stream=fStream;

END_NEW;
}


iFunc object SetBuf(object instance,char * buffer, int type, size_t size)
{
return (object) ((cast) setvbuf(IVPTR->stream,buffer,type,size));
}


iFunc object Flush(object instance)
{
return (object) ((cast) fflush(IVPTR->stream));
}



iFunc object GetPos(object instance)
{
return (object) ((cast) ftell(IVPTR->stream));
}



iFunc object SetPos(object instance, long newPos)
{
GETIVPTR;

if(newPos==0)
    {
    rewind(ivPtr->stream);
    return NULL;
    }
return (object) ((cast) fseek(ivPtr->stream,newPos,SEEK_SET));
}


iFunc object ClrErr(object instance)
{
clearerr(IVPTR->stream);
return instance;
}


iFunc object Stat(object instance)
{
GETIVPTR;

ivPtr->flags|=(feof(ivPtr->stream))?S_EOS:0;
ivPtr->flags|=(ferror(ivPtr->stream))?S_ERR:0;
return (object) ((cast)ivPtr->flags);
}


iFunc object Putc(object instance, char c)
{
return (object) ((cast) putc(c,IVPTR->stream));
}


iFunc object Getc(object instance)
{
return (object) ((cast) getc(IVPTR->stream));
}



iFunc object UnGet(object instance, char c)
{
return (object) ((cast) ungetc(c,IVPTR->stream));
}



iFunc object Puts(object instance, const char * s)
{
return (object) ((cast) fputs(s,IVPTR->stream));
}


iFunc object Gets(object instance, char *d, int max)
{
return fgets(d,max,IVPTR->stream);
}


iFunc object Write(object instance, const char * ptr, size_t size, size_t n)
{
return (object) ((cast) fwrite(ptr,size,n,IVPTR->stream));
}



iFunc object Read(object instance, char * ptr, size_t size, size_t n)
{
return (object) ((cast) fread(ptr,size,n,IVPTR->stream));
}



iFunc object Print(object instance, const char * format,...)
{
va_list ap;
cast rv;

va_start(ap,format);
rv=(cast) vfprintf(IVPTR->stream,format,ap);
va_end(ap);
return (object) rv;
}


iFunc object Scan(object instance, const char * format,...)
{
va_list ap;
cast rv;

va_start(ap,format);
rv=(cast) vfscanf(IVPTR->stream,format,ap);
va_end(ap);
return (object) rv;
}


iFunc object Acc(object instance)
{
return IVPTR->stream;
}
