/*

	Pipe  object class definition for PCOOPE2

	  Copyright (C) 1994, Brian Lee Price

	  released as PUBLIC DOMAIN 4/25/94

*/


#define CLASS Pipe

#include "pcoope2.h"

object CLASS;

extern object Sema4;
extern object Stream;
extern object Array;

instVars {
	 object readhnd;
	 object writehnd;
	 };

INSTANCEPOLY(pGetRd);
INSTANCEPOLY(pGetWr);

EXCLUDEPOLY(pGetEl);
EXCLUDEPOLY(pPutEl);
EXCLUDEPOLY(pReSz);

cFunc object New(object instance, unsigned size);
cFunc object Kill(object instance);

iFunc object GetRd(object instance);
iFunc object GetWr(object instance);


ClassInstallFunc
{
pNew(Base,0,sizeof(instVars),&CLASS,Sema4,Array,NULL);

MAKE_C_POLY(New);

MAKE_D_POLY(Kill);

MAKE_I_POLY(GetRd);
MAKE_I_POLY(GetWr);

EXCLUDE_POLY(pGetEl);
EXCLUDE_POLY(pPutEl);
EXCLUDE_POLY(pReSz);

EndClassInstall;
}





cFunc object New(object instance,unsigned size)
{
DECLAREivPtr;
BEGIN_NEW;
MakeInstance;

pNew(Sema4,1);
pNew(Array,size,sizeof(char));

ivPtr->readhnd=pNew(Stream,instance,"r");
makePerm(ivPtr->readhnd);
ivPtr->writehnd=pNew(Stream,instance,"w");
makePerm(ivPtr->writehnd);

END_NEW;
}


iFunc object GetRd(object instance)
{
return IVPTR->readhnd;
}


iFunc object GetWr(object instance)
{
return IVPTR->writehnd;
}


cFunc object Kill(object instance)
{
GETIVPTR;

pKill(ivPtr->readhnd);
pKill(ivPtr->writehnd);
pKill(Base,instance);
return instance;
}


