/*
    pcmdemo.cpp -- demo of pcmouse.cpp
    To compile: bcc pcmdemo pcmouse graphics.lib
    Copyright 1994, John W. Small, All Rights Reserved
    voice: (703) 759-3838,  email: john.small@wdn.com
*/

#define BGI_PATH "\\bc4\\bgi"

#include <conio.h>    /* clrscr(), gotoxy(), cprintf() */
#include <stdlib.h>
#include <graphics.h>
#include "pcmouse.h"

char *mice[] = {
    "Unknown", "Bus", "Serial",
    "InPort", "PS2", "HP"
};

void MouseReport()
{
    (void) cprintf("\r\nMouse Driver Version : %d.%02d",
        MM.driverVersionMajor,MM.driverVersionMinor);
    (void) cprintf("\r\nRequires : %s Mouse",mice[MM.typeRequired]);
    if (MM.present)
        (void) cprintf("\r\nMouse has %2d buttons.",MM.buttons);
    else
        (void) cprintf("\r\nMouse not connected!");
    (void) cprintf("\r\n\nMouse cursor @ (%3d,%3d)",MM.x,MM.y);
    (void) cprintf("    Left  : %s",MM.leftPressed? "Down":"Up  ");
    (void) cprintf("    Right : %s",MM.rightPressed? "Down":"Up  ");
    (void) cprintf("\r\n%s button requested",
        (MM.buttonRequested == MBleft)?
        "Left " : "Right");
    (void) cprintf("\r\nLeft:   Presses  : %3d  @ (%3d,%3d)   ",
        MM.leftPresses, MM.lastLeftPressX,
        MM.lastLeftPressY);
    (void) cprintf("Releases : %3d  @ (%3d,%3d)",
        MM.leftReleases, MM.lastLeftReleaseX,
        MM.lastLeftReleaseY);
    (void) cprintf("\r\nRight:  Presses  : %3d  @ (%3d,%3d)   ",
        MM.rightPresses, MM.lastRightPressX,
        MM.lastRightPressY);
    (void) cprintf("Releases : %3d  @ (%3d,%3d)",
        MM.rightReleases, MM.lastRightReleaseX,
        MM.lastRightReleaseY);
    (void) cprintf("\r\nMickeys :  Horz  : %10u   Vert  : %10u",
        MM.horzMickeys, MM.vertMickeys);
    (void) cprintf("\r\nEvent   :  Count : %10u   Time  : %10lu   Flags : %10u",
        MM.eventCount, MM.eventTime, MM.eventFlags);
    (void) cprintf("\r\nClicks  :  Left  : %10u   Right : %10u",
        MM.leftClicks, MM.rightClicks);
    (void) cprintf("\r\n@ time  :  Left  : %10lu   Right : %10lu",
        MM.leftClickTime, MM.rightClickTime);
}

main()
{
    unsigned ec;
    int gdriver, gmode, gerror;
    int dx, c;

    MM.open();

    textmode(C80);
    clrscr();
    gotoxy(10,20);
    cprintf("Press any key to continue ...");
    MM.show();
    MM.autoEventUpdate();
    ec = MM.eventCount;
    MM.cox1 = 1; MM.coy1 = 2;
    MM.cox2 = 71; MM.coy2 = 13;
    while (!kbhit())  {
        gotoxy(1,1);
        MM.condOff();
        MouseReport();
        MM.show();
        while ((ec == MM.eventCount) && !kbhit());
        ec = MM.eventCount;
    }
    getch();  // clear keyboard buffer

    gdriver = DETECT;
    initgraph(&gdriver, &gmode, BGI_PATH);
    gerror = graphresult();
    if (gerror != grOk)  /* an error occurred */
    {
       clrscr();
       cprintf("Not able to demo in graphics mode: %s",
        grapherrormsg(gerror));
       cprintf("\r\nPress any key to halt:");
       getch();
       exit(1);
    }
    MM.reset();  // call after any video mode change.
    directvideo = 0;  // enable conio i/o in graphics mode

    dx = getmaxx() / (getmaxcolor()+1);
    clearviewport();
    for (c = 0; c <= getmaxcolor(); c++)  {
        setfillstyle(XHATCH_FILL,c);

        bar3d(c*dx,0,(c+1)*dx,getmaxy(),0,0);
    }

    gotoxy(10,20);
    cprintf("Press any key to change cursor or ESC to quit ...");

    MM.show();
    MM.autoEventUpdate();
    ec = MM.eventCount;
    MM.cox1 = 0; MM.coy1 = 0;
    MM.cox2 = 570; MM.coy2 = 208;
    int arrow = 1;  // arrow/hand cursor toggle
    for (;;)  {
      while (!kbhit())  {
        gotoxy(1,1);  // conio remember!
        MouseReport();
        // CondOff() really belongs before MouseReport
        // because conio is so slow I put it here.
        // If you XOR_PUT to screen make sure mouse is
        // hidden by condOff() or hide() before updating!
        MM.condOff();
        MM.show();
        while ((ec == MM.eventCount) && !kbhit());
        ec = MM.eventCount;
      }
      if (getch() == 27)  // clear keyboard buffer
        break;  // forever loop
      MM.hide();
      if (arrow)  {
        MM.handGraphicsCursor();
        arrow = 0;
      }
      else  {
        MM.graphicsCursor();  // default is arrow
        arrow = 1;

      }
      MM.show();
    }

    closegraph();
    cputs("\r\nPSW / Power SoftWare");
    cputs("\r\nP.O. Box 10072");
    cputs("\r\nMcLean, Virginia 22102 8072");
    cputs("\r\n(703) 759-3838");
    cputs("\r\n");
    cputs("\r\nThat's all folks!");
    cputs("\r\n");

    MM.close();

    return 0;
}

