;$Author:   DCODY  $
;$Date:   03 Sep 1992 14:57:04  $
;$Header:   X:/sccs/misc/fmemcpy.asv   1.3   03 Sep 1992 14:57:04   DCODY  $
;$Log:   X:/sccs/misc/fmemcpy.asv  $
;  
;     Rev 1.3   03 Sep 1992 14:57:04   DCODY
;  added huge memory block copy
;  
;     Rev 1.2   24 Jul 1992 15:39:30   DCODY
;  renamed the function name, from _fmemcpy, to _rfmemcpy
;  
;     Rev 1.1   23 Jun 1992 16:32:38   DCODY
;  PAS2 update
;  
;     Rev 1.0   15 Jun 1992 09:39:50   BCRANE
;  Initial revision.
;$Logfile:   X:/sccs/misc/fmemcpy.asv  $
;$Modtimes$
;$Revision:   1.3  $

        page    64,131
	Title	fmemcpy  --  memory to memory copy

;   /*\
;---|*|
;---|*|------------====< FMEMCPY.ASM >====------------
;---|*|
;---|*| Copyright (c) 1991, Media Vision, Inc. All rights reserved
;---|*|
;   \*/

	.xlist
	include model.inc
	include masm.inc
        include common.inc
	.list

        .code

;
;   /*\
;---|*|
;---|*|------------====< void rfmemcpy ( void far *, void far *, int ) >====------------
;---|*|
;---|*| Our memory to memory copy - Copy from the source pointer to the
;---|*| target pointer of xxx length
;---|*|
;---|*| Entry Conditions:
;---|*|     dParm1 - Target far pointer
;---|*|     dParm2 - Source far pointer
;---|*|     wParm3 - Size of block move
;---|*|
;---|*| Exit Conditions:
;---|*|     returns the ending target pointer
;---|*|
;---|*| Functionality:
;---|*|
;---|*|     Clear interrupt mechanisms.
;---|*|     Disable DMA channel.
;---|*|     Set DMARunning to 0;
;---|*|
;   \*/

	public	_rfmemcpy
_rfmemcpy	proc
	push	bp
	mov	bp,sp
	push	ds
	push	es
	push	si
	push	di

	pushf
	les	di,dParm1
	lds	si,dParm2
	mov	cx,wParm5		; use wParm5 to access 5th word

        cld
	rep	movsb

	mov	dx,es			; return the ending ptr
	mov	ax,di

        popf

	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret

_rfmemcpy	endp


;
;   /*\
;---|*|
;---|*|------------====< void rfhmemcpy ( void huge*, void huge*, int ) >====------------
;---|*|
;---|*| Our huge pointer memory to memory copy - Copy from the source
;---|*| pointer to the target pointer of xxx length
;---|*|
;---|*| Entry Conditions:
;---|*|     dParm1 - Target far pointer
;---|*|     dParm2 - Source far pointer
;---|*|     wParm3 - Size of block move
;---|*|
;---|*| Exit Conditions:
;---|*|     returns the ending target pointer
;---|*|
;---|*| Functionality:
;---|*|
;---|*|     Clear interrupt mechanisms.
;---|*|     Disable DMA channel.
;---|*|     Set DMARunning to 0;
;---|*|
;   \*/

	public	_rfhmemcpy
_rfhmemcpy	 proc
	push	bp
	mov	bp,sp

        push    ds
	push	es
	push	si
	push	di

	pushf
	cld

	les	di,dParm1		; get the huge target pointer
	lds	si,dParm2		; get the huge source pointer
	mov	cx,wParm5		; use wParm5 to access 5th word
;
hcpy:
	movsb
	or	si,si			; source wrapped?
	jz	srcwrap 		; yes, go adjust it...
   sret:
	or	di,di			; destination wrapped?
	jz	trgwrap 		; yes, go adjust it...
   tret:
	loop	hcpy			; do the whole block

	mov	dx,es			; return the ending target ptr
	mov	ax,di

        popf

	pop	di
	pop	si
	pop	es
	pop	ds
	pop	bp
	ret
;
srcwrap:
	mov	ax,ds
	add	ax,1000h
	mov	ds,ax
        jmp     short sret
;
trgwrap:
	mov	ax,es
	add	ax,1000h
	mov	es,ax
	jmp	short tret

_rfhmemcpy	 endp

	end

