/*$Author:   BCRANE  $*/
/*$Date:   13 Jul 1992 11:56:42  $*/
/*$Header:   W:/sccs/mixers/dialog.h_v   1.3   13 Jul 1992 11:56:42   BCRANE  $*/
/*$Log:   W:/sccs/mixers/dialog.h_v  $
 * 
 *    Rev 1.3   13 Jul 1992 11:56:42   BCRANE
 * added defines for F5-F8 and SF5-SF8
 * 
 *    Rev 1.2   09 Jul 1992 17:45:58   BCRANE
 * added defines for F3 and shifted F3
 * 
 *    Rev 1.1   23 Jun 1992 16:44:58   DCODY
 * PAS2 update
 * 
 *    Rev 1.0   15 Jun 1992 09:41:20   BCRANE
 * Initial revision.
*/
/*$Logfile:   W:/sccs/mixers/dialog.h_v  $*/
/*$Modtimes$*/

    /*\
    |*|----=====< DIALOG.H >====----
    |*|
    |*|  This module holds the various definitions for the mixer DIALOG module
    |*|
    \*/


    /*\
    |*| New Data definitions
    \*/

	typedef unsigned int UWORD;
	typedef char BYTE;

#define TRUE	-1
#define FALSE	 0
#define ON	TRUE
#define OFF	FALSE


    /*\
    |*|----====< Messages to be passed to the action routines >====----
    \*/

#define OPEVENT 	0x0001		/* operator event		*/

#define FOCUS_GIVEN     0x0002          /* focus to button              */
#define FOCUS_TAKEN	0x0003		/* focus taken from button	*/

#define DRAWIT		0x0004		/* draw the OBJECT		*/
#define CLEARIT 	0x0005		/* clear the OBJECT area	*/
#define OPENINIT        0x0006          /* 1st call initialization      */
#define SENDIT		0x0007		/* Send command to h/w		*/


    /*\
    |*|----=====< Keyboard Values >=====----
    \*/

#define ESCAPE		0x011B		/* Escape key			*/
#define F1KEY		0x3B00		/* F1 key			*/
#define F2KEY		0x3C00		/* F2 key			*/
#define F3KEY		0x3D00		/* F3 key			*/
#define SF3KEY		0x5600		/* shifted F3 key			*/
#define F4KEY		0x3E00		/* F4 key			*/
#define F5KEY		0x3F00		/* F5 key			*/
#define SF5KEY		0x5800		/* shifted F5 key			*/
#define F6KEY		0x4000		/* F6 key			*/
#define SF6KEY		0x5900		/* shifted F6 key			*/
#define F7KEY		0x4100		/* F7 key			*/
#define SF7KEY		0x5A00		/* shifted F7 key			*/
#define F8KEY		0x4200		/* F8 key			*/
#define SF8KEY		0x5B00		/* shifted F8 key			*/
#define ENTER		0x1C0D		/* Enter key			*/
#define SH_TABKEY	0x0F00		/* shift tab key		*/
#define TABKEY          0x0F09          /* tab key                      */
#define PLUSKEY1	0x0d2b		/* +				*/
#define PLUSKEY2	0x4e2b		/* +				*/
#define MINUSKEY1	0x0c2d		/* -				*/
#define MINUSKEY2	0x4a2d		/* -				*/
#define LFARROW 	0x4b00		/* left arrow key		*/
#define RIARROW 	0x4d00		/* right arrow key		*/
#define UPARROW 	0x4800		/* upward arrow key		*/
#define DNARROW 	0x5000		/* down arrow key		*/

#define HOMEKEY 	0x4700		/* HOME key			*/
#define PGUPKEY 	0x4900		/* PGUP key			*/
#define ENDKEY		0x4F00		/* END	key			*/
#define PGDNKEY 	0x5100		/* PGDN key			*/


    /*\
    |*|----=====< Data structures >====----
    \*/

	typedef struct {
	    int row;
	    int col;
	} point;

        typedef struct {
	     int row1;
	     int col1;
	     int row2;
	     int col2;
	} rect;

	typedef struct {
	    rect wndr;
	    int row;
	    int col;
	    char attr;
	    char wrap;
	    unsigned int soff;
	    unsigned int sseg;
	} VideoStruct;


    /*\
    |*|----=====< Event Structure >====----
    \*/

    /* redefine the metawindow event structure with UWORD		*/

	typedef struct _revent {// Event record structure
	    int type;		// type of event 0=none,1=mouse,2=keybrd
	    int flags;		// bit flags from interrupt
	    int buttons;	// button state
	    int vpos;		// vertical position
	    int hpos;		// horzontal position
	    long time;		// clock tic count

	} Event, *EPtr;
     
    /* we define our own event control block to add a 'type' of event */

#define EV_MOUS 	    01		/* mouse event			*/
#define EV_KEYB 	    02		/* keyboard event		*/

#define EV_RITSHIFT	0x0001		/* right shift depressed	*/
#define EV_LEFTSHIFT	0x0002		/* left shift depressed 	*/
#define EV_CONTROL	0x0004		/* control key depressed	*/
#define EV_ALT		0x0008		/* alt key depressed		*/
#define EV_SCROLLOCK	0x0010		/* scroll lock active		*/
#define EV_NUMLOCK	0x0020		/* num lock active		*/
#define EV_CAPSLOCK	0x0040		/* caps lock active		*/
#define EV_INSERT	0x0080		/* insert active		*/

#define EV_LEFTBUTTON	0x0001		/* mouse left button depressed	*/
#define EV_MIDBUTTON	0x0002		/* mouse middle button depressed*/
#define EV_RITBUTTON	0x0004		/* mouse right button depressed */

#define EV_BUTTONS	(EV_RITBUTTON|EV_MIDBUTTON|EV_LEFTBUTTON)

#define MA_LBCHANGE	0x0100		/* left button has changed	*/
#define MA_MBCHANGE	0x0200		/* middle button has changed	*/
#define MA_RBCHANGE	0x0400		/* right button has changed	*/
#define MA_DOUBLE	0x8000		/* double click timing		*/

#define MA_BUTTONCHG   (MA_RBCHANGE|MA_MBCHANGE|MA_LBCHANGE)

    /* logical abstraction of event occurances returned by "TheMouseEvent */

#define LEFTBUTTONDOWN		0x0001	/* Left button down		*/
#define RIGHTBUTTONDOWN 	0x0002	/* right button down		*/
#define MIDBUTTONDOWN		0x0004	/* middle button down		*/

#define LEFTBUTTONHELDDOWN	0x0008	/* Left button down		*/
#define RIGHTBUTTONHELDDOWN	0x0010	/* right button down		*/
#define MIDBUTTONHELDDOWN	0x0020	/* middle button down		*/

#define LEFTBUTTONUP		0x0040	/* Left button up		*/
#define RIGHTBUTTONUP		0x0080	/* right button up		*/
#define MIDBUTTONUP		0x0100	/* middle button up		*/

#define LEFTBUTTONDOUBLEDOWN	0x0200	/* Left button double click	*/
#define RIGHTBUTTONDOUBLEDOWN	0x0400	/* right button double click	*/
#define MIDBUTTONDOUBLEDOWN	0x0800	/* middle button double click	*/

    /* amount of time between mouse key down events to make a double click */

#define DOUBLECLICK	4		/* 4 clock ticks		*/


    /*\
    |*| end of DIALOG.H
    \*/

