/*$Author:   DCODY  $*/
/*$Date:   31 Aug 1992 12:22:28  $*/
/*$Header:   X:/sccs/misc/selfilt.c_v   1.3   31 Aug 1992 12:22:28   DCODY  $*/
/*$Log:   X:/sccs/misc/selfilt.c_v  $
 * 
 *    Rev 1.3   31 Aug 1992 12:22:28   DCODY
 * renamed MVout to MVOut
 * 
 *    Rev 1.2   17 Jul 1992 14:11:28   DCODY
 * always sets the filter now, regardless of board type.
 * 
 *    Rev 1.1   23 Jun 1992 16:33:00   DCODY
 * PAS2 update
 * 
 *    Rev 1.0   15 Jun 1992 09:40:00   BCRANE
 * Initial revision.
*/
/*$Logfile:   X:/sccs/misc/selfilt.c_v  $*/
/*$Modtimes$*/

	/*\
	|*|----====< SELFILT.C >====----
	|*|
	|*| This module takes a look at the sample rate and requested filter
	|*| setting and comes up with a best match. The
	|*|
	|*| Copyright (c) 1991, Media Vision, Inc. All rights reserved.
    |*|
    \*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "pcmio.h"
#include "common.h"

  // Pro AudioSpectrum, Rev 1

	int FilterTable[] = {

		0x00,		/* 000000b	 mute - goes to PC speaker	*/
		0x24,		/* 111001b	 20hz to  2.9khz		*/
		0x39,		/* 100100b	 20hz to  5.9khz		*/
		0x31,		/* 110001b	 20hz to  8.9khz		*/
		0x29,		/* 101001b	 20hz to 11.9khz		*/
		0x22,		/* 100010b	 20hz to 15.9khz		*/
		0x21		/* 100001b	 20hz to 17.8khz		*/
	};

	static int	SetFilter	   (int);
	static int	GetSampleMax   (long);
	static int	ValidateFilter (int);


	/*\
	|*|----====< ChooseInputFilter (long, int) >====----
	|*|
	|*| Choose a good filter setting for PCM input
	|*|
	|*|
	\*/
void ChooseFilter(sr,f)
	long sr;
	int   f;
{
int srmax;

	/* if there is a filter override, use it... 						*/

		if (f != -1) {
			srmax = ValidateFilter(f);
		}
		else {

	/* get the maximum filter value for the sample						*/

			srmax = GetSampleMax(sr);
		}

	/* Set the corrected value now. 									*/

		SetFilter(srmax);

}


	/*\
	|*|----====< GetSampleMax() >====----
	|*|
	|*| Return the maximum suggested filter setting for the given sample rate
	|*|
	|*|
	\*/
static int GetSampleMax(sr)
	long sr;
{

	/* CD Quality 17897hz												*/

		if ((unsigned long) sr > (unsigned long) 17897L*2)
				return(6);

	/* Cassette Quality 15090hz 										*/

		if ((unsigned long) sr > (unsigned long) 15909L*2)
			return(5);

	/* FM Radio Quality 11931hz 										*/

		if ((unsigned long) sr > (unsigned long) 11931L*2)
			return(4);

	/* AM Radio Quality  8948hz 										*/

		if ((unsigned long) sr > (unsigned long) 8948L*2)
			return(3);

	/* Telphone Quality  5965hz 										*/

		if ((unsigned long) sr > (unsigned long) 5965L*2)
			return(2);

	/* Male voice quality 2982hz										*/

		return (1);

}


	/*\
	|*|----====< SetFilter() >====----
	|*|
	|*| Output the filter value to the hardware
	|*|
	|*|
	\*/
static int SetFilter(fs)
	int fs;
{

	/* get the actual filter data and pass it on... 					*/

		MVOut (AUDIOFILT, 0x3f, FilterTable[fs]);

}


	/*\
	|*|----====< ValidateFilter(int) >====----
	|*|
	|*| Validate the requested filter level
	|*|
	|*|
	\*/
static int ValidateFilter(f)
   int f;
{
	/* the PROAS100 board has a range of 0 - 6							*/

		if ((f < 0) || (f > 6))
			return (6); 	  /* max it out, it will be trimmed 		*/
		else
			return (f); 	  /* let it be...							*/

}

	/*\
	|*| end of SELFILT.C
	\*/

