
;   /*\
;---|*|----====< phase >====----
;---|*|
;---|*| This program demonstrates the phase effects of throwing the FM
;---|*| chips frequencies out of phase when playing a note
;---|*|
;   \*/


#include <stdio.h>

;   /*\
;---|*|----====< main >====----
;   \*/

main()
{

    // initialize the FM interface

		mvFMInitMode(1);				// 1 = split mode

	// Load the FM patch

		LoadPatch();

	// Play each side of the chip a little differently

		dophase (0);
		dophase (1);
		dophase (2);
		dophase (4);
		dophase (8);
		dophase (16);
		dophase (32);

	// turn off the audio

		outdual3812 (0xB0, 0x00, 0x00);

		printf ("\noff...\n");

}


;   /*\
;---|*|----====< dophase >====----
;---|*|
;---|*| Play each half of the FM chip with an adjusted frequency
;---|*|
;	\*/

dophase(offst)
	int offst;
{
		if (offst)
			printf ("\nfrequency off center by %d...",offst);

		else
			printf ("\nNo phase shifting...");

		outdual3812
		  (
			0xA0,
			0x6B+offst,
			0x6B-offst
		  );

        outdual3812 (0xB0, 0x35, 0x35);     // KEY-ON=1, block=5, f(9,10)=01
		outdual3812 (0xB0, 0x15, 0x15); 	// KEY-ON=0, block=5, f(9,10)=01

		printf ("type any key to continue...");
		getch();
}


;   /*\
;---|*|----====< LoadPatch >====----
;---|*|
;---|*| Load the FM chip with a patch
;---|*|
;   \*/

LoadPatch(offst)
	int offst;
{

        outdual3812 (0x20, 0x01, 0x01);     // multiple = 1

		outdual3812 (0x40, 0x00, 0x00); 	// volume on high

        outdual3812 (0x60, 0xF0, 0xF0);     // Attack  = F, Decay = 0

        outdual3812 (0x80, 0xF1, 0xF1);     // Sustain = F, Release = 1

        outdual3812 (0xC0, 0x11, 0x21);     // Left connect = 11h, right = 21h
}

