#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define OKAY 0

#include "cdmaster.h"

char *syntax= 	"Syntax: cdpause [drive #].\n";
char *nodrives= "No CDROM drives attached.\n";
char *nomscdex= "MSCDEX is not installed.\n";

main(int argc, char **argv)
{
	int numcdroms= 0;
	int ourdrive= 0;
	struct cdtable *cdt;

	if (!ismscdex())
		{
		fprintf(stderr, nomscdex);
		return(1);
		}

	if (!(numcdroms= getnumcdroms()))
		{
		fprintf(stderr, nodrives);
		return(2);
		}

	switch (argc)
		{
		case 2:
			if (!(ourdrive= atoi(argv[1])))
				{
				fprintf(stderr, syntax);
				return(3);
				}
			break;

		case 1:
			if (!(ourdrive= getfirstcdrom()))
				{
				fprintf(stderr, nodrives);
				return(4);
				}
			break;

		default:
			fprintf(stderr, syntax);
			return(5);
		}

	printf("pause drive: %2d ", ourdrive);

	if (cdt= createaudiotoc(ourdrive))
		{
		int status= cdpause(ourdrive);
		printf("= %X.\n", status);
		destroyaudiotoc(ourdrive);
		}
	else
		printf("failed, no initialization.\n");

	return(OKAY);
}
