;$Author:   DCODY  $
;$Date:   17 Jul 1992 14:25:40  $
;$Header:   W:/sccs/pcmapps/recfila.asv   1.2   17 Jul 1992 14:25:40   DCODY  $
;$Log:   W:/sccs/pcmapps/recfila.asv  $
;  
;     Rev 1.2   17 Jul 1992 14:25:40   DCODY
;  TurnItOn will only execute if TurnItOff was first called.
;  
;     Rev 1.1   23 Jun 1992 16:09:22   DCODY
;  No change.
;  
;     Rev 1.0   15 Jun 1992 09:26:46   BCRANE
;  Initial revision.
;$Logfile:   W:/sccs/pcmapps/recfila.asv  $
;$Modtimes$
;$Revision:   1.2  $
;$Workfile:   recfila.asm  $ 

	Title	recfila.asm  --  Miscellaneous assembler code for recfile.c
        page    64,131

;   /*\
;---|*|------------====< RECFILA.ASM >====------------
;---|*|
;---|*| Copyright (c) 1991, Media Vision, Inc. All rights reserved
;---|*|
;   \*/

	.xlist
	include model.inc
	include masm.inc
        include common.inc
	include binary.inc
	.list

PCMCODEVERSION	equ	0003h		; version 00.03

;
;---------------------------========================---------------------------
;---------------------------====< DATA SECTION >====---------------------------
;---------------------------========================---------------------------
;
        .data
;
; Global Data Declarations
;
	public	RightInputChannel
RightInputChannel	dw	-1	; PCm right channel
	public	LeftInputChannel
LeftInputChannel	dw	-1	; PCM left channel

	extrn	MVSetMixerFunction:dword	; set mixer function call
	extrn	MVGetMixerFunction:dword	; get mixer function call

;
;---------------------------========================---------------------------
;---------------------------====< CODE SECTION >====---------------------------
;---------------------------========================---------------------------
;
        .code
	assume ds:@data

;   /*\
;---|*|
;---|*|------------====< TurnItOff >====----------------
;---|*|
;---|*| Turn off the PCM Input Mixer channels. This avoids feedback.
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     None
;---|*|
;   \*/

    externADDR	MVInitMixerCode,FFAR	; set mixer function call

	public	TurnItOff
TurnItOff	proc
	push	bp
	mov	bp,sp
;
; initialize the mixer code.
;
	sub	ax,ax			; send a zero path
	push	ax
  if @datasize
        push    ax
  endif
	call	MVInitMixercode
	mov	sp,bp
;
; Save each setting, then turn off the PCM channels to kill feed back
;
	mov	cx,BI_INPUTMIXER
	mov	dx,BI_L_PCM
	call	dword ptr [MVGetMixerFunction]
	mov	LeftInputChannel,bx

	mov	dx,BI_R_PCM
	call	dword ptr [MVGetMixerFunction]
	mov	RightInputChannel,bx

	sub	bx,bx
	call	dword ptr [MVSetMixerFunction]

	mov	dx,BI_L_PCM
	call	dword ptr [MVSetMixerFunction]

	pop	bp
	ret

TurnItOff	endp

;
;   /*\
;---|*|------------====< TurnItOn() >====------------
;---|*|
;---|*| Restore the mixer settings for the PCM left/right channels
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     None
;---|*|
;   \*/

        public  TurnItOn
TurnItOn        proc
;
; if we didn't set the channels, then don't restore them!
;
	cmp	[RightInputChannel],-1	; did we touch these?
	jz	tuion05 		; no, just exit...
;
; restore each mixer setting									       */
;
	mov	cx,BI_INPUTMIXER
	mov	dx,BI_L_PCM
	mov	bx,LeftInputChannel
	inc	bx
	call	dword ptr [MVSetMixerFunction]

	mov	dx,BI_R_PCM
	mov	bx,RightInputChannel
	inc	bx
	call	dword ptr [MVSetMixerFunction]
;
tuion05:
	ret

TurnItOn	endp


;   /*\
;---|*| end of RECFILA.ASM
;   \*/

        end

