/*$Author:   DCODY  $*/
/*$Date:   24 Sep 1992 08:59:06  $*/
/*$Header:   X:/sccs/pcmapps/blockin.c_v   1.5   24 Sep 1992 08:59:06   DCODY  $*/
/*$Log:   X:/sccs/pcmapps/blockin.c_v  $
 * 
 *    Rev 1.5   24 Sep 1992 08:59:06   DCODY
 * changed MVGetHardware to mvGetHardware
 * 
 *    Rev 1.4   28 Jul 1992 15:52:20   DCODY
 * added TurnItOff, TurnItOn to get rid of feedback during recordings.
 * 
 *    Rev 1.3   20 Jul 1992 11:39:06   DCODY
 * call to mvGetHWVersion now uses active I/O address detection.
 * 
 *    Rev 1.2   13 Jul 1992 19:05:04   DCODY
 * removed initmvsound call. changed pcmstate to add 8 bit pcm parm.
 * 
 *    Rev 1.1   23 Jun 1992 16:09:24   DCODY
 * pas2 update...
 * 
 *    Rev 1.0   15 Jun 1992 09:26:24   BCRANE
 * Initial revision.
*/
/*$Logfile:   X:/sccs/pcmapps/blockin.c_v  $*/
/*$Modtimes$*/
/*$Revision:   1.5  $*/
/*$Workfile:   blockin.c  $*/


/* simple PCM data recorder - writes blocks of data to the disk 		*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <signal.h>
#include "pcmio.h"
#include "common.h"

char OurData[4096];

main()
{
FILE *f;

	/* abort if the hardware is not found								*/

		if (mvGetHWVersion(USE_ACTIVE_ADDR) == -1) {
			printf ("\aThe Pro AudioSpectrum hardware is not installed!\n");
			exit(1);
        }

	/* open a file														*/

		f = fopen("xxx.pcm","wb");

	/* Turn off the PCM to avoid feedback								*/

		TurnItOff();

    /* open the PCM code                                                */

		if (OpenPCMBuffering(-1,-1,16,4)) {
            printf ("\aCannot setup the PCM software!\n");
			exit(1);
        }

	/* setup the sample rate & stereo flag								*/

		PCMState (22050L, 0, 0, 8); 	/* 22050 khz, mono, 8 bit pcm	*/

	/* if the DMA engine starts, keep the data moving to disk!			*/

		if (StartBlockInput()) {

            while (1) {

				/* if ESC typed, kill the DMA & exit					*/

                    if (kbhit()) {
                        if (getch() == 0x1b) {
							StopDMAIO();
                            break;
                        }
                    }

				/* if all done, then just break 						*/

					if (ContinueBlockInput(OurData)) {
						if (fwrite (OurData,1,4096,f) != 4096) {
							StopDMAIO();
							break;
						}
					}
            }
        }

	/* exit to DOS														*/

		ClosePCMBuffering();
        close (f);

	/* restore the PCM mixer channel									*/

		TurnItOn();

		exit(0);
}

