#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define OKAY 0

#include "cdmaster.h"

char *syntax=
	"Syntax: cdplay [drive# [starttrack# [endtrack#]]].\n"
	"\tdrive#\tnumber of CDROM drive;  defaults to the first drive#\n"
	"\t\tuse '.' to specify the first drive# when specifying track#'s.\n"
	"\tstarttrack#\tstarting track number to play.\n"
	"\tendtrack#\tending track number to play.\n"
	"\t\tuse -1 to play to end of disc, -2 to play to end of track.\n";
char *nodrives= "No CDROM drives attached.\n";
char *nomscdex= "MSCDEX is not installed.\n";

main(int argc, char **argv)
{
	int bgntrack= 1;
	int endtrack= 1;
	int numcdroms= 0;
	int ourdrive= 0;
	struct cdtable *cdt;

	if (!ismscdex())
		{
		fprintf(stderr, nomscdex);
		return(1);
		}

	if (!(numcdroms= getnumcdroms()))
		{
		fprintf(stderr, nodrives);
		return(2);
		}

	switch (argc)
		{
		case 4:
			endtrack= atoi(argv[3]);
		case 3:
			bgntrack= atoi(argv[2]);
		case 2:
			if (argv[1][0] != '.')
				{
				if (!(ourdrive= atoi(argv[1])))
					{
					fprintf(stderr, syntax);
					return(3);
					}
				break;
				}

		case 1:
			if (!(ourdrive= getfirstcdrom()))
				{
				fprintf(stderr, nodrives);
				return(4);
				}
			break;

		default:
			fprintf(stderr, syntax);
			return(5);
		}

	if (endtrack == -1)
		endtrack= 99;
	else
	if (endtrack == -2)
		endtrack= bgntrack;
	else
	if (endtrack < bgntrack)
		endtrack= bgntrack;

	/* Programming Notes:
	*	Call "createaudiotoc()" to get a quick structure allocated.
	*
	*	Get the trackinfo for the desired track.  Convert the
	*	frame/min/sec/unknown bytes in trackinfo (the starting address)
	*	to a long by getting the address of the frame member and calling
	*	"redtolong()" using a pointer, but subtract 2 seconds from this
	*	value (150 frames);  it is not known why, but if you use the
	*	"starting address" as returned by the driver you actually address
	*	data 2 seconds into the disc (this is required here because
	*	"cdtrackinfo()" is a low level call (cdrom.c) and returns exactly
	*	what the driver provides, whereas "gettrackframes()" (cdmaster.c)
	*	does the adjustment for us.
	*
	*	Then, accumulate the count of frames to play for each track in the
	*	range specified on the command line.
	*
	*	Finally, "cdplay()".
	*/

	if (cdt= createaudiotoc(ourdrive))
		{
		int status= 0;
		long sframe;
		long tframes= 0;
		int track= bgntrack;
		struct trackinfo ti;

		if (status= cdtrackinfo(ourdrive, bgntrack, &ti) >= 0)
			{
			long *redaddress= (long *) &ti.frame;
			long sframe= redtolong((*redaddress)); //- (75* 2);

			do
				{
				long f= gettrackframes(ourdrive, track);

				if (f == -1)
					status= -1;
				else
				if (!f)
					if (endtrack != 99)
						status= -1;
					else
						break;
				if (status < 0)
					break;
				tframes+= f;
				}
			while (++track <= endtrack);

			printf("play drive: %2d - From: %2d - Upto: %2d ", ourdrive, bgntrack, track- 1);

			if (status >= 0)
				status= cdplay(ourdrive, sframe, tframes);
			}
		printf("= %X.\n", status);
		destroyaudiotoc(ourdrive);
		}
	else
		printf("failed, no initialization.\n");

	return(OKAY);
}

