#include <stdio.h>
#include <string.h>

/* Public Domain, by Jerry Coffin, tested with MSC 7.0 */

char *get_config(char *name, FILE *file) {

    char buffer[200];
    char a_name[100];
    static char value[100];
/* These lengths are arbitrarily selected, but should
 * be sufficient for most purposes.
 */
    size_t i,len;

    rewind(file);
    while (!feof(file)) {
        fscanf(file," %200[^\n]",buffer);
        if (';' == buffer[0] )
            continue;
/* If the line starts with a semicolon, consider it a comment.
 * ( ignore it )
 */
        sscanf(buffer," %99[^ =] = %99[^\n]",a_name,value);

/* This simply looks for some characters ending with either
 * whitespace or an equal sign, followed by an equal sign, then
 * some more characters.  Any whitespace at the beginning of the
 * line or on either side of the equal sign will be ignored.
 */

        len = strlen(a_name);
        for (i=0;i<len;i++)
            if ('_' == a_name[i] )
                memmove(a_name+i,a_name+i+1,len-i);
/* This strips underscore characters out of the name, so if any
 * are present, they will be ignored.
 */

        if (!stricmp(a_name,name))
/* stricmp is non-standard, but most compilers include it.  It
 * simply compares the two strings ignoring case.
 */
            break;
         else value[0] = '\0';
/* Otherwise, make the string empty in case it's the last in the
 * file and there were no matches.
 */
    }
    return value;
}

#ifdef TEST

int main(void) {

    FILE *config;
    char *name;

    if (NULL == (config =fopen("test.cfg","r" )))
        fprintf(stderr,"\nUnable to open configuration file");

    name = get_config("name",config);
    if (name[0])
        printf("my name is %s", get_config("name",config));
    else
        printf("I'm in bad shape - I can't even find my own name");
    fclose(config);
    return 0;
}
#endif

