/*************************************************************************
**           Paradox-Like Picture Field Input Processing
**************************************************************************
**                                                                      **
**  Copyright (c) 1992  Flexible Information Systems, Inc.              **
**                                                                      **
**    This code may be freely used by any programmer                    **
**    including royalty free inclusion in any commercial                **
**    application, but any commercial rights to the source              **
**    code or object files of this code is are reserved.                **
**                                                                      **
**    This code is supplied strictly as-is, and FIS, Inc. and the       **
**    author assume no responsibility for the accuracy, use or fitness  **
**    for a particular purpose                                          **
**                                                                      **
**                                                                      **
**      Author:         Ken Vogel                                       **
**      CIS Id:         74007,564                                       **
**      Filename:       testpic.cpp                                    **
**      Prefix:         PPIC_                                           **
**      Date:           24-Mar-92                                       **
**                                                                      **
**      Description:    Demonstrates the PARAPICT.CPP input module.
**                      Uses standard dos cputs routines
**                                                                      **
**************************************************************************/

#define Uses_TNSCollection

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>

#include "parapict.hpp"

void main(void)
{
    char PictureA[100];
    char ResultA[100];
    char *CursorP;
    Boolean Done;
 ReDo:
    printf ("\nEnter picture >");
    gets (PictureA);

    PPIC_PictureClass *PictureP = new PPIC_PictureClass (PictureA);
    if (PictureP == 0 || !PictureP->valid)
      {
        printf ("Error - invalid picture\n");
        goto ReDo;
      }
    printf ("\n:");
    int Key;

    *ResultA = 0;
    while (1)
      {
        Key = getch();
        if (Key == 27)
            exit (1);
        if (Key == 8)
          {
            // Do this to reset the string
            if (strlen (ResultA) > 0)
              {
                ResultA[ strlen (ResultA) - 1] = 0;
                char *BadP = PictureP->ReprocessString (ResultA);
                if (BadP)
                  {
                    printf ("\nBad reparse at %c\n", *BadP);
                  }
                else
                  {
                    gotoxy (2, wherey());
                    clreol();
                    cputs (ResultA);
                  }
              }
            continue;
          }
        CursorP = strchr (ResultA, 0);
        if (!PictureP->ProcessLetter ((char)Key, &Done, True, CursorP, 50))
          {
            if (Done)
                break;
            sound (440);
            delay (200);
            nosound();
          }
        else
          {
            cputs (CursorP);
          }
      }
    goto ReDo;
}

