//===================================================================
//  *** Windows ofstream emulation - Print Stream class
//  This class defines a Windows print stream which provides the same
//  functionality as the standard C++ ofstream class on a Windows
//  printer device.
//
//  Author - P. J. Weber
//  Eveready Battery Company, Inc.
//
//  $log$
//
//===================================================================
#include <owstream.h>
#include <mem.h>
#include <string.h>
//===================================================================
//  This function handles writing text out to the printer device
//
BOOL wpFilebuf::winWrite(const signed char _FAR *lpszString, int length)
{
    if (!pageStarted)   // Handle the start of a new page
    {
        StartPage(pd.hDC);
        pageStarted = TRUE;
    }

    BOOL toVal = TextOut(pd.hDC, xPos, yPos, lpszString, length);
    if (toVal)
    {
        DWORD dwExtent = GetTextExtent(pd.hDC, lpszString, length);
        xPos += LOWORD(dwExtent);
    }
    return toVal;
}

int _Cdecl wpFilebuf::printBuf(const char _FAR *string, int bufLen)
{
    error = 0;
    char buffer[IOBUFFLEN];
    char *bufPtr = buffer;

    if (bufLen == 0)
        bufLen = lstrlen(string);

    memset(buffer, 0, IOBUFFLEN);
    strncpy(buffer, string, bufLen);
    while (lstrlen(bufPtr))
    {
        int subLen = strcspn(bufPtr, "\n\f");
        if (subLen && !_fAbort && !error) // Only print if no error!
            winWrite(bufPtr, subLen);
        bufPtr += subLen;
        switch (*bufPtr)
        {
            case '\n':
                NewLine();
                break;
            case '\f':
                NewPage();
                break;
        }
        ++bufPtr;
    }
    return bufLen;
}

//===================================================================
// This function is the "Newline" handler.
//
void wpFilebuf::NewLine(void)
{
    xPos = 0;
    yPos += charHt;
    if (yPos > (pageHt - charHt))
        NewPage();
}
//===================================================================
// This function is the "Form-feed" handler.
//
void wpFilebuf::NewPage(void)
{
    xPos = yPos = 0;
    if (pageStarted && !_fAbort)
    {
        EndPage(pd.hDC);
        pageStarted = FALSE;
    }
}
//==================== Base constructors ============================
_Cdecl wpStreambase::wpStreambase() : wpBuf()
{
    state = 0;
    flags(0);
    width(0);
    precision(0);
    ispecial = ios::skipping;
    ospecial = osfx_special = isfx_special = 0;
    delbuf = 0;
    fill(' ');
}
_Cdecl wpStreambase::wpStreambase(HWND hWnd) : wpBuf(hWnd)
{
    state = 0;
    flags(0);
    width(0);
    precision(0);
    ispecial = ios::skipping;
    ospecial = osfx_special = isfx_special = 0;
    delbuf = 0;
    fill(' ');
}
_Cdecl wpStreambase::wpStreambase(
    HWND hWnd,                  // Handle to a window. MAY BE NULL
    char *docName,              // Document Name
    int flagWord,               // Flag word
    int dlgFlag,               // File flag word
    char *outFile) :            // Output file name
    wpBuf(hWnd, docName, flagWord, dlgFlag, outFile)
{
    state = 0;
    flags(flagWord);
    width(0);
    precision(0);
    ispecial = ios::skipping;
    ospecial = osfx_special = isfx_special = 0;
    delbuf = 0;
    fill(' ');
    if (wpBuf.wperror()) // Set the stream state bits if there is an open error
        setstate(badbit | hardfail);
}
