//===================================================================
//  *** Windows ofstream emulation - Print Stream class
//  This class defines a Windows print stream which provides the same
//  functionality as the standard C++ ofstream class on a Windows
//  printer device.
//
//  Author - P. J. Weber
//  Eveready Battery Company, Inc.
//
//  $log$
//
//===================================================================
#include <mem.h>
#include <ctype.h>

#include <owstream.h>
#define IOBUFF_OFFSET   4

//===================================================================
// Virtual overloads
//
streambuf _FAR * _Cdecl wpFilebuf::setbuf(signed char _FAR *buffer, int length)
{
    char *iobuff = GlobalLock(ioBuffer);    // Allocate global memory
    setb(iobuff, iobuff + IOBUFFLEN);       // Set buffer area
    setp(base() + IOBUFF_OFFSET, base() + IOBUFFLEN);   // Put area
    setg(pbase(), pbase(), pbase());                    // Get area
    memset(base(), 0, IOBUFFLEN + IOBUFF_OFFSET);       // NULL buffer
    return this;
}
//===================================================================
// Overflow the buffer - send all buffered info to the printer
//===================================================================
int _Cdecl wpFilebuf::overflow(int cVal)
{
// Flush the buffer and reset the 'put' pointers.
    printBuf(pbase(), NULL);            // Output the buffer to the printer
    setp(base() + IOBUFF_OFFSET, base() + IOBUFFLEN);
    memset(pbase(), 0, IOBUFFLEN);      // Zero the 'put' buffer
    if (isprint(cVal)) sputc(cVal);     // Don't stick NULLs into buffer
    return cVal;                        // Return the character value.
}
//===================================================================
// sync function - Establishes consistancy in internal structures
//===================================================================
int _Cdecl wpFilebuf::sync(void)
{
    return overflow(NULL);              // Return the character value.
}
//===================================================================
// This function handles all string input, including newlines and
// form feeds.
//
int _Cdecl wpFilebuf::do_sputn(const char _FAR *string, int bufLen)
{
    overflow(0);                        // Flush the buffer
    if (bufLen == 0) bufLen = lstrlen(string);
    memcpy(pptr(), string, bufLen);     // Copy the string into the buffer
    pbump(bufLen);                      // Update the buffer pointer.
    return bufLen;                      // Return the string length
}
