////////////////////////////////////////////////////////////////////////////
//       File:  CLOCKGAD.H
//    Created:  Sept 1994
//     Author:  Don Griffin (DWG)
//
//   Comments:
//
//              This header file defines the DClockGadget class.  It
//              also prototypes the FormatWinTime() function that is
//              used internally to format the clock text.
//
////////
#ifndef __CLOCKGAD_H
#define __CLOCKGAD_H

class Timer;    // defined in TIMER.H

extern char *FormatWinTime (int H, int M, int S, char *szBuf, int bufSize);
#define InitFormatWinTime()  FormatWinTime(0,0,0,0,0)

class DClockGadget : public TTextGadget
{
    protected:

        Timer       *m_pTimer;

    public:

        DClockGadget (TBorderStyle borderStyle = Recessed,
                      BOOL bShowSeconds = FALSE);
        ~DClockGadget ();

        void    Tick ();

        BOOL    IsActive () const;
        void    SetActive (BOOL bActive);
};

#endif  // __CLOCKGAD_H

