/**********************************************************************/
/*                  OWLDRP.cpp by Bob Bourbonnais                     */
/*              released to the public domain 12/09/92                */
/*        This program shows how to make a drag and drop server.      */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include <shellapi.h>  // needed for HDROP
//======================================================================
typedef struct {                // Structure for Dropping files using
   WORD  wStartOfFileNames;     // Drag and Drop
   POINT ptMouse;               // Mouse position for drop
   BOOL  fNonClientHit;         // Is the drop in the non client area
   char  szDropFile[255];       // File name to drop
} DROPFILESTRUCT, FAR *LPDROPFILESTRUCT;
//====================================================================
_CLASSDEF(TMyDialog)
class TMyDialog : public TDialog
  {
  public:
    TMyDialog(PTWindowsObject AParent, LPSTR AName, PTModule AModule);
    ~TMyDialog();
    virtual void WMLButtonDown(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];
    virtual void WMLButtonUp(RTMessage Msg) = [WM_FIRST + WM_LBUTTONUP];
    virtual void WMMouseMove(RTMessage Msg) = [WM_FIRST + WM_MOUSEMOVE];
  private:
    BOOL fDrop;                    // Drop the file flag
    BOOL fLButtonDown;             // The Left Mouse Button is down
    HCURSOR hcrsrNot;              // Cursor for not dropping
    HCURSOR hcrsrYea;              // Cursor for Yes can drop here
    HWND    hwndUnderCursor;       // Window to drop into
    POINT ptNewMouse;              // Current Mouse position
  };
//-----------------------------------------------------------------------
TMyDialog::TMyDialog(PTWindowsObject AParent,  // Constructor
		     LPSTR AName,              // Loads cursors and
		     PTModule AModule=NULL)    // clears flags
	    :TDialog(AParent,AName,AModule)
    {
    hcrsrNot     = LoadCursor(GetApplication()->hInstance, "NOT");
    hcrsrYea     = LoadCursor(GetApplication()->hInstance, "YEA");
    fLButtonDown = FALSE;
    fDrop        = FALSE;
    }
//-----------------------------------------------------------------------
void TMyDialog::WMLButtonDown(RTMessage)    // Left Mouse Button Down
  {
  SetCapture(HWindow);   // Grab mouse messages outside of window
  fLButtonDown = TRUE;   // The button is down
  }
//-------------------------------------------------------------------------
void TMyDialog::WMMouseMove(RTMessage)     // Mouse is moving
  {
  if (fLButtonDown)                        // if LButtonDown then drag
    {
    GetCursorPos(&ptNewMouse);             // Get Cursor position & check
    hwndUnderCursor = WindowFromPoint(ptNewMouse);  // window under it to
    if ((IsWindow(hwndUnderCursor)) &&              // see if window
	(GetWindowLong(hwndUnderCursor,GWL_EXSTYLE) // can accept drop files
	& WS_EX_ACCEPTFILES))
      {
      fDrop = TRUE;                    // Yes then set flag to drop files
      SetCursor(hcrsrYea);             // and change cursor to show drop
      }
    else
      {
      fDrop = FALSE;                   // No, then clear flag to drop files
      SetCursor(hcrsrNot);             // and change cursor to not drop
      }
    }
  }
//-----------------------------------------------------------------------
void TMyDialog::WMLButtonUp(RTMessage)  // Release left mouse buttong
  {
  fLButtonDown = FALSE;  // The button is up
  ReleaseCapture();      // Stop grabbing the mouse messages outside window
  if (fDrop)             // If it is OK to drop the file
    {
    HDROP hDrop = GlobalAlloc(GMEM_SHARE    |   // allocate memory for
			      GMEM_MOVEABLE |   // drop file structure
			      GMEM_ZEROINIT,    // that is cleaned up by
			      sizeof(DROPFILESTRUCT) + 1); //dropfile client
    if (hDrop == NULL)
      MessageBox(NULL,"Memory Allocation Failed","In Drop Struct",MB_OK);
    else
      {
      LPDROPFILESTRUCT lpDropFileStruct =       // Lock and load up structure
	(LPDROPFILESTRUCT) GlobalLock(hDrop);
      lpDropFileStruct->wStartOfFileNames =
	sizeof(DROPFILESTRUCT) - 255;
      ScreenToClient(hwndUnderCursor, &ptNewMouse);
      lpDropFileStruct->ptMouse = ptNewMouse;
      lpDropFileStruct->fNonClientHit =
	(SendMessage(hwndUnderCursor, WM_NCHITTEST, 0,
	  MAKELPARAM(ptNewMouse.x, ptNewMouse.y))
	 != HTCLIENT);
      lstrcpy(lpDropFileStruct->szDropFile,_argv[0]);
      GlobalUnlock(hDrop);
      PostMessage(hwndUnderCursor, WM_DROPFILES, hDrop, 0L); // pass it to
      }                                                      // drag and drop
    }                                                        // client window
  }
//-----------------------------------------------------------------------
TMyDialog::~TMyDialog()             // destructor cleans up cursors
    {
    DestroyCursor(hcrsrNot);
    DestroyCursor(hcrsrYea);
    }
//========================================================================
class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};
    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };
//-------------------------------------------------------------------------
void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog(NULL, "MAINWINDOWDIALOG");
  }
//==========================================================================
int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
//==========================================================================
