/**********************************************************************/
/*                  Dlgmodal.cpp by Bob Bourbonnais                   */
/*              released to the public domain 12/12/91                */
/*              This program demonstrates a dialog box                */
/*             with a menu and two buttons that can call              */
/*          a modal dialog box from either the menu or a button.      */
/*          A modal dialog box will not let you do anything in        */
/*          the current program window until it is delt with.         */
/*          You can change windows and do something in another        */
/*           program when a normal model dialog box is open.          */
/*          To force all programs to wait for a model dialog          */
/*           make it system modal.  Refer to the system modal         */
/*                     dialog program for an example.                 */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "dlgmodal.h"

class TDialog2Dialog : public TDialog    // Dialog class to add
  {					 // processing for menu and
  public:				 // button selections
    TDialog2Dialog(LPSTR lpName)         // constructor calls
      :TDialog(NULL,lpName) {};		 // base class constructor
    virtual void HandleMenuItem(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_MODAL_DIALOG];
    virtual void HandleButtonMessage(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_MODAL_DIALOG];   // close button handled by
  };                                     // base class button handler
void TDialog2Dialog:: HandleMenuItem(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }               //ExecDialog activates a modal dialog box
void TDialog2Dialog:: HandleButtonMessage(RTMessage)
  {
  GetApplication()->ExecDialog(new TDialog(this,"Modal_Dialog_Box"));
  }

class TDialog2App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog2App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog2App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TDialog2Dialog("Main_Window_Dialog");
  }                                // using message processing provided
				   // by derived class

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog2App Dialog2("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog2.Run();                                  // run it
  return (Dialog2.Status);                        // exit
  }
/**********************************************************************/
