//  Borland Paradox Engine 3.0 Database Framework program example
//  Copyright (c) 1992 by Borland International   
//  Modified DBF example...
//  CREATTBL - provides an example showing how to create a table
//             using the Database Framework.
//
//  This example uses the createTable member function of the
//  BDatabase class to create a new table defined by the array
//  of field descriptors fldArray.
//

#include <iostream.h>
#include <string.h>

// Paradox Engine 3.0 Header files.

#include <pxengine.h>
#include <envdef.h>   // Environment definitions for Database Framework.
#include <bengine.h>  // Header file for the BEngine class.
#include <bdatabas.h> // Header file for the BDatabase class.
#include <windows.h>
// Specify the name of the table you want to create.

const char *tblName = "table1";
void CreateTable( HWND& HWindow)
{  // Fill in the FieldDesc structure for every field in the table.

// Call the BEngine constructor and initialize the engine to
// single user or "PXInit()" mode.

BEngine Eng(pxWin);
 if (Eng.lastError != PXSUCCESS)
  MessageBox(HWindow, Eng.getErrorMessage(Eng.lastError),
       "Engine error: ", MB_OK);
  else
  MessageBox(HWindow, tblName, "Engine OK", MB_OK);
// Create and open the BDatabase instance DB with respect
// to the BEngine instance Eng.

BDatabase DB(&Eng);
 if (DB.lastError != PXSUCCESS)
  MessageBox(HWindow, Eng.getErrorMessage(DB.lastError),
       "Database error: ", MB_OK);
  else
  MessageBox(HWindow, tblName, "data base OK", MB_OK);
// Array of field descriptors for the table, needed for the
// createTable member function in the BDatabase class.

FieldDesc fldArray[3];

// Number of fields in the table.

const int numFields = sizeof(fldArray) / sizeof(fldArray[0]);


  fldArray[0].fldNum = 1;
  strcpy(fldArray[0].fldName, "Name");
  fldArray[0].fldType = fldChar;  // Create an alphanumeric field.
  fldArray[0].fldLen = 50;        // Specify the length of the field.

  fldArray[1].fldNum = 2;
  strcpy(fldArray[1].fldName, "Address");
  fldArray[1].fldType = fldChar;
  fldArray[1].fldLen = 50;

  fldArray[2].fldNum = 3;
  strcpy(fldArray[2].fldName, "Age");
  fldArray[2].fldType = fldShort;  // Create a short field.

  // Create the table 'tblName' with the structure provided in the
  // array of field descriptors fldArray.

  DB.createTable(tblName, numFields, fldArray);

  // Check to see if there was an error.

  if (DB.lastError != PXSUCCESS)
  MessageBox(HWindow, Eng.getErrorMessage(DB.lastError),
       "table create error: ", MB_OK);
  else
  MessageBox(HWindow, tblName, "table created successfully", MB_OK);

 // return DB.lastError;

}
