/**********************************************************************/
/*                  BWMYBTN.cpp by Bob Bourbonnais                    */
/*              released to the public domain 1/26/92                 */
/*          This program shows how to switch to different             */
/*           routines based on the button pressed using               */
/*           Dynamic Dispatched Virtual Tables, DDVT                  */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC

class TMyDialog : public TDialog
  {
  public:
    TMyDialog(LPSTR lpDialogName)          // constructor calls
      : TDialog(NULL,lpDialogName)         // base class constructor
      {
      BWCCGetVersion();    // activate Borland Windows Custom Controls
      }
   // The following Dynamic Dispatch Virtual Functions are linked
    // to their associated subroutines

    virtual void HandleTest(RTMessage Msg)
      = [ID_FIRST + 110];                    // The test button has ID of 110
    virtual void HandleGo(RTMessage Msg)
      = [ID_FIRST + 120];                    // The Go button has ID of 120

    virtual void DefChildProc(RTMessage Msg);  // Default handler for
					       // Buttons not covered
					       // by DDVT
  };

void TMyDialog::HandleTest(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Test Button was pressed",
			  "Button ID of 110 was pressed",MB_OK);
  }
void TMyDialog::HandleGo(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Go button was pressed",
			 "Button ID of 120 was pressed",MB_OK);
  }

void TMyDialog::DefChildProc(RTMessage Msg)
  {
  MessageBeep(0);
  BWCCMessageBox(HWindow,"Not Implemented","Feature",MB_OK);
  MessageBeep(0);
  TDialog::DefChildProc(Msg);
  }

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
