/**********************************************************************/
/*                  BWCKALL.cpp by Bob Bourbonnais                    */
/*              released to the public domain 2/02/92                 */
/*          This program shows how to switch to different             */
/*            routines based on the button pressed using              */
/*              Dynamic Dispatched Virtual Tables, DDVT               */
/*      It also shows how to use pointers to BWCC check boxes         */
/*           to show the ON/OFF status of the check boxes             */
/*        and to set the initial state via the check command          */
/*         It demonstrates immediate and delayed processing.          */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC
#include "bchkbox.h"                     // needed for BWCC checkboxs
#include "BWCKALL.H"                     // equates for checkboxes

class TMyDialog : public TDialog
  {
  public:
    TBCheckBox *pcbRadar12, *pcbConfabulator12,  // pointers to check boxes
	       *pcbRadar13, *pcbConfabulator13;
    TMyDialog(LPSTR lpDialogName);              // constructor

    virtual void SetupWindow();  // SetupWindow is called after dialog box
				 // is created and is used for initialization
				 // of controls.
    virtual void Ok(RTMessage Msg);        // redefines the DDVT function
					   // for the OK button #1
					   // as defined in Base class
					   // TDialog

    virtual void HandleRadar12(RTMessage Msg)  // these DDVT toggles
      = [ID_FIRST + IDB_RADAR12];              // activate immediately
    virtual void HandleConfabulator12(RTMessage Msg) // like regular
      = [ID_FIRST + IDB_CONFABULATOR12];             // buttons

    virtual void DefChildProc(RTMessage Msg); // default button handler
  };

void TMyDialog::TMyDialog(LPSTR lpDialogName)  // constructor calls
	      : TDialog(NULL,lpDialogName)     // base class constructor
  {
  BWCCGetVersion();    // activate Borland Windows Custom Controls

  pcbRadar12 = new TBCheckBox(this,IDB_RADAR12,NULL);    //links up
  pcbConfabulator12 = new TBCheckBox(this,               //pointers
				     IDB_CONFABULATOR12, //to check boxes
				     NULL);              //That were made
  pcbRadar13 = new TBCheckBox(this,IDB_RADAR13,NULL);    //in the .RC
  pcbConfabulator13 = new TBCheckBox(this,               //via the
				     IDB_CONFABULATOR13, //workshop
				     NULL);
  }

void TMyDialog::SetupWindow()    // called after dialog box is displayed
  {
  TDialog::SetupWindow();        // call base class set up
  pcbRadar13->Check();           // check Radar13 and Confabulator13
  pcbConfabulator13->Check();
  }

void TMyDialog::Ok(RTMessage Msg)  // Redefines button handler inherited
  {                                // from TDailog for Button #1 IDOK
  char szMyString[180];

  if (pcbRadar13->GetCheck()==BF_CHECKED)           // find out the ON/OFF
    {                                               // status
    lstrcpy(szMyString,"Radar Unit 13 is Activated.\n");
    }
  else
    {
    lstrcpy(szMyString,"Radar Unit 13 is Shutdown.\n");
    }

  if (pcbConfabulator13->GetCheck()==BF_CHECKED)           // find out the ON/OFF
    {
    lstrcat(szMyString,"The Confabulator on Unit 13 is Activated.");
    }
  else
    {
    lstrcat(szMyString,"The Confabulator on Unit 13 is OFF.");
    }

  BWCCMessageBox(HWindow,szMyString,"Update on Unit #13",MB_OK); //output
								 //status
  TDialog::Ok(Msg);     //default OK handler to close dialog box
  }

void TMyDialog::HandleRadar12(RTMessage)            // immediately
  {
  if (pcbRadar12->GetCheck()==BF_CHECKED)           // find out the ON/OFF
    {                                               // status of the checkbox
						    // using a pointer to the
						    // checkbox
    MessageBeep(0);                                 // if we turned it on
    BWCCMessageBox(HWindow,"Radar Unit 12 Activated", // beep and display
			   "ACTIVATION!",MB_OK);      // message box
    }
  else                                              // if we turned it off
    {
    MessageBeep(0);                                 // beep and display a
    BWCCMessageBox(HWindow,"Radar Unit 12 OFF",     // different message
			   "SHUTDOWN!",MB_OK);
    }
  }

void TMyDialog::HandleConfabulator12(RTMessage)     // Same for second
  {                                                 // Item
  if (pcbConfabulator12->GetCheck()==BF_CHECKED)
    {
    MessageBeep(0);
    BWCCMessageBox(HWindow,"Confabulator on Unit 12 Activated",
			   "ACTIVATION!",MB_OK);
    }
  else
    {
    MessageBeep(0);
    BWCCMessageBox(HWindow,"Confabulator on Unit 12 OFF",
			   "SHUTDOWN!",MB_OK);
    }
  }

void TMyDialog::DefChildProc(RTMessage Msg)   // default button handler
  {
  if ((Msg.WParam == IDB_RADAR13)|(Msg.WParam == IDB_CONFABULATOR13))
    {          // If either of the unit #13 buttons are pressed then
    TDialog::DefChildProc(Msg);  // pass message along to base class
    }                            // to check the box
  else
    {
    MessageBeep(0);                             // make sound and display
    BWCCMessageBox(HWindow,"Not Implemented",   // a BWCC message box
		  "Feature",MB_OK);
    TDialog::DefChildProc(Msg);                 // pass messages along
    }                                           // to base class handler
  }

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
