/**********************************************************************/
/*                  BWCCMSBX.cpp by Bob Bourbonnais                   */
/*              released to the public domain 1/12/92                 */
/*            This program demonstrates a main dialog box             */
/*              with a menu and buttons that call all                 */
/*      predefined BWCC message boxes and message beep functions.     */
/*      BWCCMessageBox is easy to use.  It is a direct replacement    */
/*          for the standard MessageBox command in Windows.           */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "BWCC.h"                        // Needed for BWCC
#include "bwccmsbx.h"                    // Equates for menu and buttons

class TDialog3Dialog : public TDialog    // Dialog class to add
  {					 // processing for menu and
  public:				 // button selections
    TDialog3Dialog(LPSTR lpName)         // constructor calls
      :TDialog(NULL,lpName) 		 // base class constructor.
       {                                 // BWCCGetVersion activates
       BWCCGetVersion();                 // BWCC library
       }
    virtual void HandleMenuAbortRetryIgnore(RTMessage Msg) // menu handlers
      = [CM_FIRST + IDM_ABORTRETRYIGNORE];
    virtual void HandleMenuIconAsterisk(RTMessage Msg)
      = [CM_FIRST + IDM_ICONASTERISK];
    virtual void HandleMenuIconExclamation(RTMessage Msg)
      = [CM_FIRST + IDM_ICONEXCLAMATION];
    virtual void HandleMenuIconHand(RTMessage Msg)
      = [CM_FIRST + IDM_ICONHAND];
    virtual void HandleMenuIconInformation(RTMessage Msg)
      = [CM_FIRST + IDM_ICONINFORMATION];
    virtual void HandleMenuIconQuestion(RTMessage Msg)
      = [CM_FIRST + IDM_ICONQUESTION];
    virtual void HandleMenuIconStop(RTMessage Msg)
      = [CM_FIRST + IDM_ICONSTOP];
    virtual void HandleMenuOK(RTMessage Msg)
      = [CM_FIRST + IDM_OK];
    virtual void HandleMenuOKCancel(RTMessage Msg)
      = [CM_FIRST + IDM_OKCANCEL];
    virtual void HandleMenuRetryCancel(RTMessage Msg)
      = [CM_FIRST + IDM_RETRYCANCEL];
    virtual void HandleMenuYesNo(RTMessage Msg)
      = [CM_FIRST + IDM_YESNO];
    virtual void HandleMenuYesNoCancel(RTMessage Msg)
      = [CM_FIRST + IDM_YESNOCANCEL];
    virtual void HandleMenuMessageBeep(RTMessage Msg)
      = [CM_FIRST + IDM_MESSAGEBEEP];
    virtual void HandleMenuMessageBeepLoop(RTMessage Msg)
      = [CM_FIRST + IDM_MESSAGEBEEPLOOP];

    virtual void HandleButtonAbortRetryIgnore(RTMessage Msg)// button handlers
      = [ID_FIRST + IDB_ABORTRETRYIGNORE];
    virtual void HandleButtonIconAsterisk(RTMessage Msg)
      = [ID_FIRST + IDB_ICONASTERISK];
    virtual void HandleButtonIconExclamation(RTMessage Msg)
      = [ID_FIRST + IDB_ICONEXCLAMATION];
    virtual void HandleButtonIconHand(RTMessage Msg)
      = [ID_FIRST + IDB_ICONHAND];
    virtual void HandleButtonIconInformation(RTMessage Msg)
      = [ID_FIRST + IDB_ICONINFORMATION];
    virtual void HandleButtonIconQuestion(RTMessage Msg)
      = [ID_FIRST + IDB_ICONQUESTION];
    virtual void HandleButtonIconStop(RTMessage Msg)
      = [ID_FIRST + IDB_ICONSTOP];
    virtual void HandleButtonOK(RTMessage Msg)
      = [ID_FIRST + IDB_OK];
    virtual void HandleButtonOKCancel(RTMessage Msg)
      = [ID_FIRST + IDB_OKCANCEL];
    virtual void HandleButtonRetryCancel(RTMessage Msg)
      = [ID_FIRST + IDB_RETRYCANCEL];
    virtual void HandleButtonYesNo(RTMessage Msg)
      = [ID_FIRST + IDB_YESNO];
    virtual void HandleButtonYesNoCancel(RTMessage Msg)
      = [ID_FIRST + IDB_YESNOCANCEL];
    virtual void HandleButtonMessageBeep(RTMessage Msg)
      = [ID_FIRST + IDB_MESSAGEBEEP];
    virtual void HandleButtonMessageBeepLoop(RTMessage Msg)
      = [ID_FIRST + IDB_MESSAGEBEEPLOOP];

    void DisplayStatus(int nStatus); // display status of buttons pressed
				     // when within message boxes
  };
void TDialog3Dialog:: HandleMenuAbortRetryIgnore(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
			  "Title of Message Box",MB_ABORTRETRYIGNORE);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconAsterisk(RTMessage)
  {
  int nStatus;
  nStatus = MessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONASTERISK);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconExclamation(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONEXCLAMATION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconHand(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONHAND);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconInformation(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONINFORMATION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconQuestion(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONQUESTION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuIconStop(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONSTOP);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuOK(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OK);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuOKCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OKCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuRetryCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_RETRYCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuYesNo(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_YESNO);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuYesNoCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_YESNOCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleMenuMessageBeep(RTMessage)
  {
  MessageBeep(0);
  }
void TDialog3Dialog:: HandleMenuMessageBeepLoop(RTMessage)
  {
  int i;
    for(i=0;i<100;i++)
      MessageBeep(0);
  }


void TDialog3Dialog:: HandleButtonAbortRetryIgnore(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ABORTRETRYIGNORE);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconAsterisk(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONASTERISK);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconExclamation(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONEXCLAMATION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconHand(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONHAND);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconInformation(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONINFORMATION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconQuestion(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONQUESTION);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonIconStop(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_ICONSTOP);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonOK(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OK);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonOKCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_OKCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonRetryCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_RETRYCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonYesNo(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_YESNO);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonYesNoCancel(RTMessage)
  {
  int nStatus;
  nStatus = BWCCMessageBox(HWindow,"Message inside of Message Box",
		       "Title of Message Box",MB_YESNOCANCEL);
  DisplayStatus(nStatus);
  }
void TDialog3Dialog:: HandleButtonMessageBeep(RTMessage)
  {
  MessageBeep(0);
  }
void TDialog3Dialog:: HandleButtonMessageBeepLoop(RTMessage)
  {
  int i;
    for(i=0;i<100;i++)
      MessageBeep(0);
  }


void TDialog3Dialog::DisplayStatus(int nStatus)
  {
  char szBuffer[40];
  switch (nStatus)
    {
    case IDABORT:
      wsprintf(szBuffer,"The Abort Button sent number %d",nStatus);
      break;
    case IDCANCEL:
      wsprintf(szBuffer,"The Cancel Button sent number %d",nStatus);
      break;
    case IDIGNORE:
      wsprintf(szBuffer,"The Ignore Button sent number %d",nStatus);
      break;
    case IDNO:
      wsprintf(szBuffer,"The No Button sent number %d",nStatus);
      break;
    case IDOK:
      wsprintf(szBuffer,"The OK Button sent number %d",nStatus);
      break;
    case IDRETRY:
      wsprintf(szBuffer,"The Retry Button sent number %d",nStatus);
      break;
    case IDYES:
      wsprintf(szBuffer,"The Yes Button sent number %d",nStatus);
      break;
    default:
      wsprintf(szBuffer,"Out of Range Value  %d Passed",nStatus);
    }
    int i;
    if (nStatus > 0)
       BWCCMessageBox(HWindow,szBuffer,"Button Message",MB_OK);
    else 	      //not enough memory to create message box
       for (i=0;i<100;i++)MessageBeep(0);     // so beep instead
  }


/* ===================================================================== */
class TDialog3App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog3App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog3App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TDialog3Dialog("Main_Window_Dialog");
  }                                // using message processing provided
				   // by derived class

/**************************************************************************/
int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog3App Dialog3("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog3.Run();                                  // run it
  return (Dialog3.Status);                        // exit
  }
/**************************************************************************/
