/**********************************************************************/
/*                  BWRPOINT.cpp by Bob Bourbonnais                   */
/*              released to the public domain 2/2/92                  */
/*          This program shows how to process radio buttons           */
/*               using Pointers to the radio buttons.                 */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC
#include "bradio.h"                      // needed for BWCC radio buttons
#include "bwradely.h"                    // needed for equates

class TMyDialog : public TDialog
  {
  public:
    TBRadioButton *pUnit12Test  , *pUnit12Phase1, // pointers to
		  *pUnit12Phase2, *pUnit12Phase3, // radio buttons
		  *pUnit13Test  , *pUnit13Phase1,
		  *pUnit13Phase2, *pUnit13Phase3;
    TMyDialog(LPSTR lpDialogName);            // Constructor
    virtual void Ok(RTMessage Msg);           // redefines the DDVT function
					      // for the OK button #1
					      // as defined in Base class
					      // TDialog
    virtual void DefChildProc(RTMessage Msg); // default button handler
  };

void TMyDialog::TMyDialog(LPSTR lpDialogName) // constructor calls
	      : TDialog(NULL,lpDialogName)    // base class constructor
  {
  BWCCGetVersion();    // activate Borland Windows Custom Controls

  pUnit12Test   = new TBRadioButton(this,IDB_UNIT12_TEST,  NULL); //links up
  pUnit12Phase1 = new TBRadioButton(this,IDB_UNIT12_PHASE1,NULL); //Radio
  pUnit12Phase2 = new TBRadioButton(this,IDB_UNIT12_PHASE2,NULL); //Button
  pUnit12Phase3 = new TBRadioButton(this,IDB_UNIT12_PHASE3,NULL); //Pointers
  pUnit13Test   = new TBRadioButton(this,IDB_UNIT13_TEST,  NULL); //with
  pUnit13Phase1 = new TBRadioButton(this,IDB_UNIT13_PHASE1,NULL); //Radio
  pUnit13Phase2 = new TBRadioButton(this,IDB_UNIT13_PHASE2,NULL); //Buttons
  pUnit13Phase3 = new TBRadioButton(this,IDB_UNIT13_PHASE3,NULL); //defined
								  //in .RC
  }

void TMyDialog::Ok(RTMessage Msg)  // Redefines button handler inherited
  {                                // from TDailog for Button #1 IDOK
  char szMyString[180];

  if (pUnit12Test->GetCheck()==BF_CHECKED)           // find out the ON/OFF
    {                                                // status
    lstrcpy(szMyString,"Unit #12 is in Test Mode.\n");
    }
  else if (pUnit12Phase1->GetCheck()==BF_CHECKED)
    {
    lstrcpy(szMyString,"Unit #12 is in Phase 1 of Operation.\n");
    }
  else if (pUnit12Phase2->GetCheck()==BF_CHECKED)
    {
    lstrcpy(szMyString,"Unit #12 is in Phase 2 of Operation.\n");
    }
  else
    {
    lstrcpy(szMyString,"Unit #12 is in Phase 3 of Operation.\n");
    }

  if (pUnit13Test->GetCheck()==BF_CHECKED)
    {                                                   // status
    lstrcat(szMyString,"Unit #13 is in Test Mode.\n");
    }
  else if (pUnit13Phase1->GetCheck()==BF_CHECKED)
    {
    lstrcat(szMyString,"Unit #13 is in Phase 1 of Operation.\n");
    }
  else if (pUnit13Phase2->GetCheck()==BF_CHECKED)
    {
    lstrcat(szMyString,"Unit #13 is in Phase 2 of Operation.\n");
    }
  else
    {
    lstrcat(szMyString,"Unit #13 is in Phase 3 of Operation.\n");
    }

  BWCCMessageBox(HWindow,szMyString,"Update on Unit #12",MB_OK); //output
								 //status
  TDialog::Ok(Msg);     //default OK handler to close dialog box
  }

void TMyDialog::DefChildProc(RTMessage Msg)   // default button handler
  {
  if ((Msg.WParam >= IDB_UNIT12_TEST)&(Msg.WParam <= IDB_UNIT13_PHASE3))
    {          // If a radio button is pressed then
    TDialog::DefChildProc(Msg);  // pass message along to base class
    }                            // to check the box
  else
    {
    MessageBeep(0);                             // make sound and display
    BWCCMessageBox(HWindow,"Not Implemented",   // a BWCC message box
		   "Feature",MB_OK);
    TDialog::DefChildProc(Msg);                 // pass messages along
    }                                           // to base class handler
  }

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
