/**********************************************************************/
/*                  BWCDELAY.cpp by Bob Bourbonnais                   */
/*              released to the public domain 1/28/92                 */
/*          This program shows how to switch to perform               */
/*           delayed processing of check boxes in reply               */
/*            to an OK button using SendDlgItemMessages               */
/*                 to get the status of the buttons.                  */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC
#include "bwcdelay.h"

class TMyDialog : public TDialog
  {
  public:
    TMyDialog(LPSTR lpDialogName)          // constructor calls
      : TDialog(NULL,lpDialogName)         // base class constructor
      {
      BWCCGetVersion();    // activate Borland Windows Custom Controls
      }
    virtual void Ok(RTMessage Msg);        // redefines the DDVT function
					   // for the OK button #1
					   // as defined in Base class
					   // TDialog
    virtual void DefChildProc(RTMessage Msg); // default button handler
  };

void TMyDialog::Ok(RTMessage Msg)  // Redefines button handler inherited
  {                                // from TDailog for Button #1 IDOK
  char szMyString[180];

  if (SendDlgItemMsg(IDB_RADAR12,BM_GETCHECK,0,0))  // check on button
    {                                               // status
    lstrcpy(szMyString,"Radar Unit 12 is Activated.\n");
    }
  else
    {
    lstrcpy(szMyString,"Radar Unit 12 is Shutdown.\n");
    }

  if (SendDlgItemMsg(IDB_CONFABULATOR12,BM_GETCHECK,0,0)) // button status
    {
    lstrcat(szMyString,"The Confabulator on Unit 12 is Activated.");
    }
  else
    {
    lstrcat(szMyString,"The Confabulator on Unit 12 is OFF.");
    }

  BWCCMessageBox(HWindow,szMyString,"Update on Unit #12",MB_OK); //output
								 //status
  TDialog::Ok(Msg);     //default OK handler to close dialog box
  }

void TMyDialog::DefChildProc(RTMessage Msg)   // default button handler
  {
  if ((Msg.WParam == IDB_RADAR12)|(Msg.WParam == IDB_CONFABULATOR12))
    {          // If either of the unit #12 buttons are pressed then
    TDialog::DefChildProc(Msg);  // pass message along to base class
    }                            // to check the box
  else
    {
    MessageBeep(0);                             // make sound and display
    BWCCMessageBox(HWindow,"Not Implemented",   // a BWCC message box
		   "Feature",MB_OK);
    TDialog::DefChildProc(Msg);                 // pass messages along
    }                                           // to base class handler
  }

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
