/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : init_dsk.c
   date     	  : 21.11.1993
   last change	  : 21.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This functions puts the logical OS9 Format information
   on the preformatted Disk.

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             21.11.93  WEW
*****************************************************************************/
#include <mem.h>
#include <dos.h>
#include "os9.h"
#include "mdos.h"
#include "prototyp.h"

short init_dsk(drive,fm_type)
short drive;              /* 0 - Drive A:, 1 Drive B: */
short fm_type;            /* UNI - OS9 Universal Format */
                          /* X8W7 - Os9 38w7 or 58w7 format */
{
    struct date l_date;
    struct time l_time;
    unsigned long lsn;
    short alloc_size;
    short count;
    short err;
    short i;
    extern ddsect id_sect38w7;
    extern ddsect id_sectuni;
    extern fildes root_dir;  /* is for Universal and x8w7 format identical */
    unsigned char sector[512];
    unsigned char new_map[1024];
    unsigned long clu_size;


    err=0;
    memset(sector,0,256);
    memset(&new_map[0],0xff,1024);
    sector[0]='.';
    sector[1]='.'|0x80;
    sector[0x20]='.'|0x80;

    getdate(&l_date);
    gettime(&l_time);

    switch (fm_type)
    {

        case UNIVERSAL:
            alloc_size=(id_sectuni.dd_map[0]<<8) + id_sectuni.dd_map[1];
            memset(&new_map[0],0,alloc_size);

            memcpy(&sector[0x1d],&id_sectuni.dd_dir[0],3);
            memcpy(&sector[0x3d],&id_sectuni.dd_dir[0],3);
            id_sectuni.dd_date[0] = (unsigned char)(l_date.da_year-1900);
            id_sectuni.dd_date[1] = l_date.da_mon;
            id_sectuni.dd_date[2] = l_date.da_day;

            id_sectuni.dd_date[3] = l_time.ti_hour;
            id_sectuni.dd_date[4] = l_time.ti_min;

            err=rw_lsn(drive,WRITE,0,1,&id_sectuni); /* write ID Sector */

            clu_size=(id_sectuni.dd_bit[0]<<8)+(id_sectuni.dd_bit[1]);
            /* Get Root dir FileDescLSN */
            lsn = (id_sectuni.dd_dir[0]<<16) +
                   (id_sectuni.dd_dir[1]<<8)+ id_sectuni.dd_dir[2];
            break;
        case X8W7:
            alloc_size=(id_sect38w7.dd_map[0]<<8) + id_sect38w7.dd_map[1];
            memset(&new_map[0],0,alloc_size);

            memcpy(&sector[0x1d],&id_sect38w7.dd_dir[0],3);
            memcpy(&sector[0x3d],&id_sect38w7.dd_dir[0],3);
            id_sect38w7.dd_date[0] = (unsigned char)(l_date.da_year-1900);
            id_sect38w7.dd_date[1] = l_date.da_mon;
            id_sect38w7.dd_date[2] = l_date.da_day;

            id_sect38w7.dd_date[3] = l_time.ti_hour;
            id_sect38w7.dd_date[4] = l_time.ti_min;

            err=rw_lsn(drive,WRITE,0,1,&id_sect38w7); /* write ID Sector */

            clu_size=(id_sect38w7.dd_bit[0]<<8)+(id_sect38w7.dd_bit[1]);
            /* Get Root dir FileDescLSN */
            lsn = (id_sect38w7.dd_dir[0]<<16) +
                   (id_sect38w7.dd_dir[1]<<8)+ id_sect38w7.dd_dir[2];


            break;
        default:
            return(UNKNOWN);
    }
    root_dir.fd_date[0] = root_dir.fd_dcr[0] = (unsigned char)(l_date.da_year-1900);
    root_dir.fd_date[1] = root_dir.fd_dcr[1] = l_date.da_mon;
    root_dir.fd_date[2] = root_dir.fd_dcr[2] = l_date.da_day;

    root_dir.fd_date[3]=l_time.ti_hour;
    root_dir.fd_date[4]=l_time.ti_min;

    /* create Allocation map */
    mark_bit(0,1,&new_map[0],clu_size);  /*  Mark sector  0  */
    /* mark cluster for Allocation Map */
    mark_bit(ALLOC_START,ALLOC_SIZE,&new_map[0],clu_size);
    scan_des(lsn,&root_dir,&new_map[0],clu_size); /* scan root dir */
    err=rw_lsn(drive,WRITE,ALLOC_START,ALLOC_SIZE,&new_map[0]);

    /* write Root dir file Descriptor */
    err=rw_lsn(drive,WRITE,lsn,1,&root_dir);

    count=(root_dir.fd_seg[0].size[0]<<8) +
            (root_dir.fd_seg[0].size[1]);


    lsn = (root_dir.fd_seg[0].addr[0] << 16) +
           (root_dir.fd_seg[0].addr[1] << 8) +
            (root_dir.fd_seg[0].addr[2]);

    err=rw_lsn(drive,WRITE,lsn,1,sector);
    lsn++;
    count--;
    memset(sector,0,256);
    for (i=lsn;i<(lsn+count);i++)
    {
        err=rw_lsn(drive,WRITE,i,1,sector);
    }


    return(err);
}
