/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 -Format
 -----------------------------------------------------------------------------
   file-name	  : Setdisk.c
   date     	  : 23.11.1993
   last change	  : 23.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This function sets the disk type directly in the
   BIOS data area.
   40:90 drive a: 0
   40:91 drive b: 1
   The Toshiba T5200 computer need additional a call of int13 with function
   17 to set the proper disk type.

   media state drive 0, 1
   floppy_media_state
   bit 7,6 Data transfer rate
           00 - 500 K/sec
           01 - 300 K/sec
           10 - 250 K/sec
           11 - reserved
       5   double stepping required
           1 - double stepping
           0 - no double stepping
       4   media/drive determined
           1 - media/drive determined, 0 - not determined
       3   reserved
       2-0 present state
           000  trying 360k in 360k drive (undetermined)
           001  trying 360k in 1.2M drive (undetermined)
           010  trying 1.2M in 1.2M drive (undetermined)
           011  known 360k in 360k (determined)
           100  known 360k in 1.2M (determined)
           101  known 1.2M in 1.2M (determined)
           110  reserved, not used
           111  known 3.5" drive (determined)

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             23.11.93  WEW
*****************************************************************************/
#include "mdos.h"
#include "prototyp.h"

void setdisk(drive,drv)
short drive;
drv_typ *drv;
{

    char huge *fdmeds;
    short type;

    if (drive==0)
    {
        fdmeds = LW_TYP_A;
        type=drv->lwa;
    }
    else
    {
        fdmeds=LW_TYP_B;
        type=drv->lwb;
    }

    /* the goal is the use of a 80 Trk Double Density Disk */
    switch(type)
    {
        case 1:
             *fdmeds=0x93; /* 360k drive */
             /* it is assumed that this is 5 1/4" 80 Track DD Drive */
             break;
        case 2:
             *fdmeds=0x54; /* 1,2MB drive */
             break;
        case 3:
             *fdmeds=0x97; /* 720k drive */
             break;
        case 4:
             *fdmeds=0x97; /* 1,44MB drive */
             break;
    }
}
