/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : os9fmt.c
   date     	  : 21.11.1993
   last change	  : 17.01.1994
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This is the main function for the program OS9 Format

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             21.11.93  WEW
   function init_disk called with '0' instead of 'drive'       17.01.94  WEW
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <errno.h>
#include "os9.h"
#include "mdos.h"
#include "prototyp.h"

short os9_type;

int main(argc,argv)
int argc;
char *argv[];

{
    short y;
    short type_valid;
    int i;
    unsigned char buffer[1024];
    int err;
    short drive;
    short drv_valid;
    unsigned short ch;
    int drvno;




    drvno=0;
    type_valid=FALSE;
    drv_valid=FALSE;
    drive=0;
    y=wherey();
    window(1,1,80,25);
    gotoxy(1,y);
    printf("OS9 38W7 / 58W7 / Universal Format Program 1.02 !\n\n");

    disk_conf();

    if ((strcmp(argv[1],"?") == NULL) ||
        (strcmp(argv[1],"-?") == NULL) ||
         (strcmp(argv[1],"/?") == NULL) ||
          (stricmp(argv[1],"/h") == NULL) ||
           (stricmp(argv[1],"h") == NULL) || (argc <=1))
    {
        printf("OS9 Disk Format Programm \n\n");
        printf("no Options , ?, -?, /?, /h or h shows help Info\n\n");
        printf("osfmt <drive> [format]\n\n\n");
        printf("Example 'os9fmt a: w7' formats floppy in Drive a: with x8W7 Format\n");
        printf("Example 'os9fmt b: un' formats floppy in Drive b: with Universal Format\n");
        printf("\n");
        printf("\n");
        exit(0);
    }
    dpbvec(INIT);
    ctrlbrk(brk_hand);

    /* Scan arguments */
    for (i=1;i<argc;i++)
    {
        if (stricmp(argv[i],"a:") == NULL)
        {
            drvno=i;
            drive=0;
            drv_valid=TRUE;
        }
        else
        {
            if (stricmp(argv[i],"b:") == NULL)
            {
                drvno=i;
                drive=1;
                drv_valid=TRUE;
            }
        }
        if (stricmp(argv[i],"w7") == NULL)
        {
            os9_type=X8W7;
            type_valid=TRUE;
        }
        else
        {
            if (stricmp(argv[i],"un") == NULL)
            {
                os9_type=UNIVERSAL;
                type_valid=TRUE;
            }
        }
    }

    /* check Arguments */
    if (drv_valid == FALSE)
    {
        printf("Specified Drive not valid ! \n");
        exit(1);
    }
    if (type_valid==FALSE)
    {
        os9_type=X8W7;     /* default is X8W7 Format */
    }
    if (os9_type==X8W7)
    {
        printf("Format %s (%d) in X8W7 Format. OK ? (Y/N) ",argv[drvno],drive);
    }
    else
    {
        printf("Format %s (%d) in UNIVERSAL Format. OK ? (Y/N) ",argv[drvno],drive);
    }

    fflush(stdout);     /* clear output Buffer */
    fflush(stdin);      /* clear input Buffer */
    ch=getch();
    printf("\n\n");
    if (((ch&0xff)=='y') || ((ch&0xff)=='Y')) ;
    else
    {
        printf("Program aborted ..... \n");
        exit(0);
    }


    err=biosdisk(0,drive,0,0,0,1,buffer);
    if (err != 0) p_err(err);

    err=setd17(drive);
    if (err != 0)
    {
        p_err(err);
    }


    y=wherey();
    for (i=0;i<80;i++)
    {
        gotoxy(1,y);
        cprintf("Track %2d, Head 0 ",i);
        fflush(stdout);
        err=format(drive,0,i,OS9);
        if (err != 0 )
        {
            p_err(err);
        }
        gotoxy(1,y);
        cprintf("Track %2d, Head 1 ",i);
        fflush(stdout);
        err=format(drive,1,i,OS9);
        if (err != 0 )
        {
            p_err(err);
        }
    }
    printf("\n\nInitialize Floppy Disk with OS9 specific logical Information\n");

    err=init_dsk(drive,os9_type);
    if (err !=0)
    {
        printf("Error %d during initialisation of Disk occured\n",err);
        exit(err);
    }

    printf("Format successful !!! \n");
    exit(0);
}